<?php

// Load WebENGINE
include('../includes/webengine.php');

// Check if user is logged in
if(!isLoggedIn()) { redirect(); }

// Check if user has access
if(!canAccessAdminCP($_SESSION['username'])) { redirect(); }

$admincp_sidebar = array(
	array('News Management',''),
		array('Publish News','addnews'),
		array('Manage News','managenews'),
	array('Account Management',''),
		array('Retrieve Account Information','accountinfo'),
		array('Find Account Characters','accountchars'),
		array('Find Character\'s Account','charsaccount'),
		array('Find Account\'s IP Addresses','accountips'),
		array('Find Accounts from IP','accountsfromip'),
		array('Online Accounts','onlineaccounts'),
	array('Credits Management',''),
		array('Latest PayPal Donations','latestpaypal'),
		array('Latest SuperRewards Donations','latestsr'),
		array('Add Credits','addcredits'),
		array('Substract Credits','substractcredits'),
);
?>
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <title>WebEngine AdminCP</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="WebEngine AdminCP v1.0">
    <meta name="author" content="Lautaro Angelico">

    <!-- Le styles -->
    <link href="css/bootstrap.css" rel="stylesheet">
    <style type="text/css">
      body {
        padding-top: 60px;
        padding-bottom: 40px;
      }
      .sidebar-nav {
        padding: 9px 0;
      }
    </style>
    <link href="css/bootstrap-responsive.css" rel="stylesheet">

    <!-- HTML5 shim, for IE6-8 support of HTML5 elements -->
    <!--[if lt IE 9]>
      <script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
    <![endif]-->

    <!-- Fav and touch icons -->
    <link rel="apple-touch-icon-precomposed" sizes="144x144" href="ico/apple-touch-icon-144-precomposed.png">
    <link rel="apple-touch-icon-precomposed" sizes="114x114" href="ico/apple-touch-icon-114-precomposed.png">
      <link rel="apple-touch-icon-precomposed" sizes="72x72" href="ico/apple-touch-icon-72-precomposed.png">
                    <link rel="apple-touch-icon-precomposed" href="ico/apple-touch-icon-57-precomposed.png">
                                   <link rel="shortcut icon" href="ico/favicon.png">
  </head>

  <body>

    <div class="navbar navbar-inverse navbar-fixed-top">
      <div class="navbar-inner">
        <div class="container-fluid">
          <a class="btn btn-navbar" data-toggle="collapse" data-target=".nav-collapse">
            <span class="icon-bar"></span>
            <span class="icon-bar"></span>
            <span class="icon-bar"></span>
          </a>
          <a class="brand" href="index.php">WebEngine AdminCP</a>
          <div class="nav-collapse collapse">
            <p class="navbar-text pull-right">
              Logged in as <?php echo $_SESSION['username']; ?>, <a href="<?php echo __BASE_URL__.'logout/'; ?>" class="navbar-link">logout</a>
            </p>
            <ul class="nav">
              <li class="active"><a href="index.php">Home</a></li>
              <li><a href="<?php echo __BASE_URL__; ?>" target="_blank">Website Home</a></li>
              <li><a href="http://www.muengine.org/" target="_blank">WebEngine Support</a></li>
            </ul>
          </div><!--/.nav-collapse -->
        </div>
      </div>
    </div>

    <div class="container-fluid">
      <div class="row-fluid">
        <div class="span3">
          <div class="well sidebar-nav">
			<ul class="nav nav-list">
			<?php
			foreach($admincp_sidebar as $sidebarItem) {
				if(!check_value($sidebarItem[1])) {
					echo '<li class="nav-header">'.$sidebarItem[0].'</li>';
				} else {
					if($_REQUEST['module'] == $sidebarItem[1]) {
						echo '<li class="active"><a href="'.__PATH_ADMINCP_HOME__.'index.php?module='.$sidebarItem[1].'">'.$sidebarItem[0].'</a></li>'; 
					} else {
						echo '<li><a href="'.__PATH_ADMINCP_HOME__.'index.php?module='.$sidebarItem[1].'">'.$sidebarItem[0].'</a></li>'; 
					}
				}
			}
			?>
			</ul>
          </div><!--/.well -->
        </div><!--/span-->
        <div class="span9">
			<?php $handler->loadAdminCPModule($_REQUEST['module']); ?>
        </div><!--/span-->
      </div><!--/row-->

      <hr>

      <footer>
        <p>&copy; Lautaro Angelico 2013 - WebEngine</p>
      </footer>

    </div><!--/.fluid-container-->

    <!-- Le javascript
    ================================================== -->
    <!-- Placed at the end of the document so the pages load faster -->
    <script src="js/jquery.js"></script>
    <script src="js/bootstrap-transition.js"></script>
    <script src="js/bootstrap-alert.js"></script>
    <script src="js/bootstrap-modal.js"></script>
    <script src="js/bootstrap-dropdown.js"></script>
    <script src="js/bootstrap-scrollspy.js"></script>
    <script src="js/bootstrap-tab.js"></script>
    <script src="js/bootstrap-tooltip.js"></script>
    <script src="js/bootstrap-popover.js"></script>
    <script src="js/bootstrap-button.js"></script>
    <script src="js/bootstrap-collapse.js"></script>
    <script src="js/bootstrap-carousel.js"></script>
    <script src="js/bootstrap-typeahead.js"></script>

  </body>
</html>