<h2>Manage News</h2>
<?php

$News = new News();
// Check if News cache folder is writable
if($News->isNewsDirWritable()) {

	// Delete news process::
	if(check_value($_REQUEST['delete'])) {
		$deleteNews = $News->removeNews($_REQUEST['delete']);
		$News->cacheNews();
		$News->updateNewsCacheIndex();
		if($deleteNews) {
			message('success','News successfully deleted');
		} else {
			message('error','Invalid news ID');
		}
	}
	
	// Cache news process::
	if(check_value($_REQUEST['cache']) && $_REQUEST['cache'] == 1) {
		$cacheNews = $News->cacheNews();
		$News->updateNewsCacheIndex();
		if($cacheNews) {
			message('success','News successfully cached');
		} else {
			message('error','Unknown error');
		}
	}

	
	$news_list = $News->retrieveNews();
	if(is_array($news_list)) {
		echo '<table class="table table-hover">';
		echo '<thead>';
		echo '<tr>';
		echo '<td style="font-weight:bold;">#</td>';
		echo '<td style="font-weight:bold;">TITLE</td>';
		echo '<td style="font-weight:bold;">AUTHOR</td>';
		echo '<td style="font-weight:bold;">DATE</td>';
		echo '<td style="font-weight:bold;">ALLOW COMMENTS</td>';
		echo '<td style="font-weight:bold;"></td>';
		echo '</tr>';
		echo '</thead>';
		echo '<tbody>';
		foreach($news_list as $thisNews) {
			if($thisNews['allow_comments'] == 1) {
				$thisNews_allowcomments = 'yes';
			} else {
				$thisNews_allowcomments = 'no';
			}
			echo '<tr>';
			echo '<td>'.$thisNews['news_id'].'</td>';
			echo '<td>'.$thisNews['news_title'].'</td>';
			echo '<td>'.$thisNews['news_author'].'</td>';
			echo '<td>'.date("m/d/Y @ h:i a",$thisNews['news_date']).'</td>';
			echo '<td>'.$thisNews_allowcomments.'</td>';
			echo '<td>
            <a class="btn btn-mini" href="index.php?module=editnews&edit='.$thisNews['news_id'].'">edit</a>
			<a class="btn btn-mini" href="'.__BASE_URL__.'news/'.Encode_id($thisNews['news_id']).'/" target="_blank">open</a>
			<a class="btn btn-danger btn-mini" href="index.php?module='.$_REQUEST['module'].'&delete='.$thisNews['news_id'].'"><i class="icon-remove icon-white"></i> delete</a>
			</td>';
			echo '</tr>';
		}
		echo '</tbody>';
		echo '</table>';
	}
	
	echo '<a class="btn btn-info" href="index.php?module='.$_REQUEST['module'].'&cache=1">UPDATE NEWS CACHE</a>';

} else {
	message('error','The news cache folder is not writable.');
}

?>