<?php
/* -----------------------------------------------------------
	Super Rewards API
	
		Parameters:
					id = transaction id
					new = amount of points
					total = total number of points accumulated
					uid = user id
					oid = SuperRewards offer identifier
					sig = security hash
					
		Response: 1 | 0
		
		Error Codes:
					100 = missing parameters
					101 = signature integrity
					102 = invalid account
					103 = account online
		
----------------------------------------------------------- */

// Load WebEngine
include('../includes/webengine.php');

// Load Configs
$sr['secret'] = config('sr_secret',true);

// SR.Parameters
$id = $_REQUEST['id'];
$new = $_REQUEST['new'];
$total = $_REQUEST['total'];
$uid = $_REQUEST['uid']; // username
$oid = $_REQUEST['oid'];
$sig = $_REQUEST['sig'];

// SR.Signature
$signature = md5($id . ':' . $new . ':' . $uid . ':' . $sr['secret']);

// Catch ERROR
$error = false;

// Check Parameters
if(!check_value($id) || !check_value($new) || !check_value($total) || !check_value($uid) || !check_value($oid) || !check_value($sig)) {
	$error = true;
	$code = 100;
}

// Validate Signature Integrity
if($sig != $signature) {
	$error = true;
	$code = 101;
}

// Check if Account Exists
if(!$common->userExists($uid)) {
	$error = true;
	$code = 102;
}

// Check if Account is Online
if($common->accountOnline($uid)) {
	$error = true;
	$code = 103;
}

// Retrieve user ID
$user_id = $common->retrieveUserID($uid);
	
// Check Error(s)
if(!$error) {
	
	// Add Credits
	$add_credits = $common->addCredits($user_id,$new);
	
	if($add_credits) {
		// Add Logs
		$add_logs_data = array(
			$id,
			$user_id,
			$new,
			time()
		);
		
		$add_logs = $dB->query("INSERT INTO "._TBL_SUPERREWARDS_." (transaction_id,user_id,credits_amount,transaction_date) VALUES (?, ?, ?, ?)", $add_logs_data);
		
		// Response
		die('1');
	} else {
		// Log Error + code
		$add_error_logs_data = array(
			$id,
			$user_id,
			$new,
			time(),
			$code
		);
		
		$add_error_logs = $dB->query("INSERT INTO "._TBL_SUPERREWARDS_ERRORS_." (transaction_id,user_id,credits_amount,transaction_date,error_code) VALUES (?, ?, ?, ?, ?)", $add_error_logs_data);
		
		// Response
		die('0');
	}
} else {
	// Log Error + code
	$add_error_logs_data = array(
		$id,
		$user_id,
		$new,
		time(),
		$code
	);
		
	$add_error_logs = $dB->query("INSERT INTO "._TBL_SUPERREWARDS_ERRORS_." (transaction_id,user_id,credits_amount,transaction_date,error_code) VALUES (?, ?, ?, ?, ?)", $add_error_logs_data);
		
	// Response
	die('0');
}


?>