<?php

class Character {

	function CharacterReset($username,$character_name,$userid) {
		global $dB,$common;
		if(check_value($username) && check_value($character_name)) {
			if(!Validator::Number($userid)) { $error = true; }
			if(!Validator::UsernameLength($username)) { $error = true; }
			if(!Validator::AlphaNumeric($username)) { $error = true; }
			if(!$error) {
				$character_name = Decode($character_name);
				if($this->CharacterExists($character_name) && $this->CharacterBelongsToAccount($character_name,$username)) {
					if(!$common->accountOnline($username)) {
					
						$characterData = $this->CharacterData($character_name);
						if($this->hasRequiredLevel($characterData[_CLMN_CHR_LVL_])) {
							if(config('resets_enable_zen_requirement',true)) {
								$deductZen = $this->DeductZEN($character_name, config('resets_price_zen',true));
								if($deductZen) {
									$zen_ok = true;
								} else {
									$zen_ok = false;
								}
							} else {
								$zen_ok = true;
							}
							
							if($zen_ok) {
								
								$update = $dB->query("UPDATE "._TBL_CHR_." SET 
								"._CLMN_CHR_LVL_." = 1,
								"._CLMN_CHR_RSTS_." = "._CLMN_CHR_RSTS_." + 1 
								WHERE "._CLMN_CHR_NAME_." = '$character_name'");
								
								if($update) {
									
									// SUCCESS
									message('success', config('success_8',true));
									
									if(config('resets_enable_credit_reward',true)) {
										// GIVE REWARD
										$amount = config('resets_credits_reward',true);
										//$reward = $this->giveReward($userid, $amount);
										$reward = $common->addCredits($userid, $amount);
										if($reward) {
											message('success',config('reset_reward_1b',true).$amount.config('reset_reward_1c',true), config('reset_reward_1a',true));
										}
									}
									
								} else {
									// unknown error (could not update database)
									message('error', lang('error_23',true));
								}
								
							} else {
								// not enough zen
								message('error', lang('error_34',true));
							}
						} else {
							// does not have the required level
							message('error', lang('error_33',true));
						}
					} else {
						// account is online
						message('error', lang('error_14',true));
					}
				} else {
					// character doesnt exist or does not belong to account
					message('error', lang('error_32',true));
				}
			} else {
				// unknown error (bad username)
				message('error', lang('error_23',true));
			}
		} else {
			// unknown error (incomplete data)
			message('error', lang('error_23',true));
		}
	}
	
	function CharacterResetStats($username,$character_name,$userid) {
		global $dB,$common;
		if(check_value($username) && check_value($character_name)) {
			if(!Validator::Number($userid)) { $error = true; }
			if(!Validator::UsernameLength($username)) { $error = true; }
			if(!Validator::AlphaNumeric($username)) { $error = true; }
			if(!$error) {
				$character_name = Decode($character_name);
				if($this->CharacterExists($character_name) && $this->CharacterBelongsToAccount($character_name,$username)) {
					if(!$common->accountOnline($username)) {
					
						$characterData = $this->CharacterData($character_name);
							if(config('resetstats_enable_zen_requirement',true)) {
								$deductZen = $this->DeductZEN($character_name, config('resetstats_price_zen',true));
								if($deductZen) {
									$zen_ok = true;
								} else {
									$zen_ok = false;
								}
							} else {
								$zen_ok = true;
							}
							
							if($zen_ok) {
								
									// some data
									$new_stats = config('resetstats_new_stats',true);
									$chr_str = $characterData[_CLMN_CHR_STAT_STR_];
									$chr_agi = $characterData[_CLMN_CHR_STAT_AGI_];
									$chr_vit = $characterData[_CLMN_CHR_STAT_VIT_];
									$chr_ene = $characterData[_CLMN_CHR_STAT_ENE_];
									$chr_cmd = $characterData[_CLMN_CHR_STAT_CMD_];
									
								if($chr_cmd >= 1) {
									$levelup_points = ($chr_str+$chr_agi+$chr_vit+$chr_ene+$chr_cmd) - ($new_stats*5);
									if($levelup_points < 1) { $levelup_points = 0; }
									$update_query = "UPDATE "._TBL_CHR_." SET 
									"._CLMN_CHR_STAT_STR_." = $new_stats, 
									"._CLMN_CHR_STAT_AGI_." = $new_stats, 
									"._CLMN_CHR_STAT_VIT_." = $new_stats, 
									"._CLMN_CHR_STAT_ENE_." = $new_stats, 
									"._CLMN_CHR_STAT_CMD_." = $new_stats, 
									"._CLMN_CHR_LVLUP_POINT_." = "._CLMN_CHR_LVLUP_POINT_." + $levelup_points 
									WHERE "._CLMN_CHR_NAME_." = '$character_name'";
								} else {
									$levelup_points = (($chr_str+$chr_agi+$chr_vit+$chr_ene)-($new_stats*4));
									if($levelup_points < 1) { $levelup_points = 0; }
									$update_query = "UPDATE "._TBL_CHR_." SET 
									"._CLMN_CHR_STAT_STR_." = $new_stats, 
									"._CLMN_CHR_STAT_AGI_." = $new_stats, 
									"._CLMN_CHR_STAT_VIT_." = $new_stats, 
									"._CLMN_CHR_STAT_ENE_." = $new_stats, 
									"._CLMN_CHR_LVLUP_POINT_." = "._CLMN_CHR_LVLUP_POINT_." + $levelup_points 
									WHERE "._CLMN_CHR_NAME_." = '$character_name'";
								}
								
								$update = $dB->query($update_query);
								
								if($update) {
									
									// SUCCESS
									message('success', lang('success_9',true));
									
								} else {
									// unknown error (could not update database)
									message('error', lang('error_23',true));
								}
								
							} else {
								// not enough zen
								message('error', lang('error_34',true));
							}
					} else {
						// account is online
						message('error', lang('error_14',true));
					}
				} else {
					// character doesnt exist or does not belong to account
					message('error', lang('error_35',true));
				}
			} else {
				// unknown error (bad username)
				message('error', lang('error_23',true));
			}
		} else {
			// unknown error (incomplete data)
			message('error', lang('error_23',true));
		}
	}
	
	function CharacterClearPK($username,$character_name) {
		global $dB,$common;
		if(check_value($username) && check_value($character_name)) {
			if(!Validator::UsernameLength($username)) { $error = true; }
			if(!Validator::AlphaNumeric($username)) { $error = true; }
			if(!$error) {
				$character_name = Decode($character_name);
				if($this->CharacterExists($character_name) && $this->CharacterBelongsToAccount($character_name,$username)) {
					if(!$common->accountOnline($username)) {
					
						$characterData = $this->CharacterData($character_name);
						if(config('clearpk_enable_zen_requirement',true)) {
							$deductZen = $this->DeductZEN($character_name, config('clearpk_price_zen',true));
							if($deductZen) {
								$zen_ok = true;
							} else {
								$zen_ok = false;
							}
						} else {
							$zen_ok = true;
						}
						
						if($zen_ok) {
							
							$update = $dB->query("UPDATE "._TBL_CHR_." SET 
							"._CLMN_CHR_PK_LEVEL_." = 3,
							"._CLMN_CHR_PK_TIME_." = 0 
							WHERE "._CLMN_CHR_NAME_." = '$character_name'");
							
							if($update) {
								
								// SUCCESS
								message('success', lang('success_10',true));
								
							} else {
								// unknown error (could not update database)
								message('error', lang('error_23',true));
							}
							
						} else {
							// not enough zen
							message('error', lang('error_34',true));
						}
					} else {
						// account is online
						message('error', lang('error_14',true));
					}
				} else {
					// character doesnt exist or does not belong to account
					message('error', lang('error_36',true));
				}
			} else {
				// unknown error (bad username)
				message('error', lang('error_23',true));
			}
		} else {
			// unknown error (incomplete data)
			message('error', lang('error_23',true));
		}
	}
	
	function CharacterUnstuck($username,$character_name) {
		global $common;
		if(check_value($username) && check_value($character_name)) {
			if(!Validator::UsernameLength($username)) { $error = true; }
			if(!Validator::AlphaNumeric($username)) { $error = true; }
			if(!$error) {
				$character_name = Decode($character_name);
				if($this->CharacterExists($character_name) && $this->CharacterBelongsToAccount($character_name,$username)) {
					if(!$common->accountOnline($username)) {
					
						$characterData = $this->CharacterData($character_name);
						if(config('unstuck_enable_zen_requirement',true)) {
							$deductZen = $this->DeductZEN($character_name, config('unstuck_price_zen',true));
							if($deductZen) {
								$zen_ok = true;
							} else {
								$zen_ok = false;
							}
						} else {
							$zen_ok = true;
						}
						
						if($zen_ok) {
							
							// MOVE CHARACTER TO LORENCIA BAR (DEFAULT COORDS)
							$update = $this->moveCharacter($character_name,0,125,125);
							
							if($update) {
								
								// SUCCESS
								message('success', lang('success_11',true));
								
							} else {
								// unknown error (could not update database)
								message('error', lang('error_23',true));
							}
							
						} else {
							// not enough zen
							message('error', lang('error_34',true));
						}
					} else {
						// account is online
						message('error', lang('error_14',true));
					}
				} else {
					// character doesnt exist or does not belong to account
					message('error', lang('error_37',true));
				}
			} else {
				// unknown error (bad username)
				message('error', lang('error_23',true));
			}
		} else {
			// unknown error (incomplete data)
			message('error', lang('error_23',true));
		}
	}
	
	function CharacterClearSkillTree($username, $character_name) {
		global $common;
		if(check_value($username) && check_value($character_name)) {
		if(!Validator::UsernameLength($username)) { $error = true; }
		if(!Validator::AlphaNumeric($username)) { $error = true; }
		if(!$error) {
				//$character_name = Decode($character_name);
				
				if($this->CharacterExists($character_name) && $this->CharacterBelongsToAccount($character_name,$username)) {
					if(!$common->accountOnline($username)) {
					
						$characterData = $this->CharacterData($character_name);
						$characterMLData = $this->getMasterLevelInfo($character_name);

						if(config('clearst_enable_zen_requirement',true)) {
							$deductZen = true; //$this->DeductZEN($character_name, config('clearst_price_zen',true));
							if($deductZen) {
								$zen_ok = true;
							} else {
								$zen_ok = false;
							}
						} else {
							$zen_ok = true;
						}
						if($characterMLData['MasterLevel']==0) {
						    return;
						}
						if($zen_ok) {
							
								// CLEAR CHARACTER MASTER SKILL TREE DATA
								$update = $this->resetMasterLevelData($character_name);
								
								// CLEAR MAGICLIST DATA
								$update_2 = $this->resetMagicList($character_name);
								
								if($update && $update_2) {
									message('success',lang('success_12',true));
									return true;
								} else {
									message('error', lang('error_23',true));
								}
							//if($this->hasRequiredMasterLevel($characterMLData[_CLMN_ML_LVL_])) {
							//} else {
							//	message('error', lang('error_39',true).config('clearst_required_level',true));
							//}
						} else {
							// not enough zen
							message('error', lang('error_34',true));
						}
					} else {
						// account is online
						message('error', lang('error_14',true));
					}
				} else {
					// character doesnt exist or does not belong to account
					message('error', lang('error_38',true));
				}
			} else {
				// unknown error (bad username)
				message('error', lang('error_23',true));
			}
		} else {
			// unknown error (incomplete data)
			message('error', lang('error_23',true));
		}
	}
	
	function CharacterAddStats($username,$character_name,$str=0,$agi=0,$vit=0,$ene=0,$com=0) {
		global $dB,$common;
		if(check_value($username) && check_value($character_name)) {
			if(!Validator::UsernameLength($username)) { $error = true; }
			if(!Validator::AlphaNumeric($username)) { $error = true; }
			if(!$error) {
				$character_name = Decode($character_name);
				if($this->CharacterExists($character_name) && $this->CharacterBelongsToAccount($character_name,$username)) {
					if(!$common->accountOnline($username)) {
					
						$characterData = $this->CharacterData($character_name);
						
							// DO THE THING HERE :D
							
							if($str < 1) { $str = 0; }
							if($agi < 1) { $agi = 0; }
							if($vit < 1) { $vit = 0; }
							if($ene < 1) { $ene = 0; }
							if($com < 1) { $com = 0; }
							
							$total_add_points = $str+$agi+$vit+$ene+$com;
							if($total_add_points >= config('addstats_minimum_add_points',true)) {
								if($total_add_points <= $characterData[_CLMN_CHR_LVLUP_POINT_]) {
									
									if($characterData[_CLMN_CHR_CLASS_] == 50 || $characterData[_CLMN_CHR_CLASS_] == 64 || $characterData[_CLMN_CHR_CLASS_] == 66) {
										// DL
										$error = false;
									} else {
										// ALL OTHER CLASSES
										if($com >= 1) {
											$error = true;
										} else {
											$error = false;
										}
									}
									
									if(!$error) {
										
										$max_stats = config('addstats_max_stats',true);
										$sum_str = $str+$characterData[_CLMN_CHR_STAT_STR_];
										$sum_agi = $agi+$characterData[_CLMN_CHR_STAT_AGI_];
										$sum_vit = $vit+$characterData[_CLMN_CHR_STAT_VIT_];
										$sum_ene = $ene+$characterData[_CLMN_CHR_STAT_ENE_];
										$sum_com = $com+$characterData[_CLMN_CHR_STAT_CMD_];
										
										$error = false;
										if($sum_str > $max_stats) { $error = true; }
										if($sum_agi > $max_stats) { $error = true; }
										if($sum_vit > $max_stats) { $error = true; }
										if($sum_ene > $max_stats) { $error = true; }
										if($sum_com > $max_stats) { $error = true; }
										
										if(!$error) {
										
											if(config('addstats_enable_zen_requirement',true)) {
												$deductZen = $this->DeductZEN($character_name, config('addstats_price_zen',true));
												if($deductZen) {
													$zen_ok = true;
												} else {
													$zen_ok = false;
												}
											} else {
												$zen_ok = true;
											}
											
											if($zen_ok) {
												$query = $dB->query("UPDATE "._TBL_CHR_." SET 
												"._CLMN_CHR_STAT_STR_." = "._CLMN_CHR_STAT_STR_." + $str,
												"._CLMN_CHR_STAT_AGI_." = "._CLMN_CHR_STAT_AGI_." + $agi,
												"._CLMN_CHR_STAT_VIT_." = "._CLMN_CHR_STAT_VIT_." + $vit,
												"._CLMN_CHR_STAT_ENE_." = "._CLMN_CHR_STAT_ENE_." + $ene,
												"._CLMN_CHR_STAT_CMD_." = "._CLMN_CHR_STAT_CMD_." + $com,
												"._CLMN_CHR_LVLUP_POINT_." = "._CLMN_CHR_LVLUP_POINT_." - $total_add_points 
												WHERE "._CLMN_CHR_NAME_." = '$character_name'");
												
												if($query) {
													// SUCCESS
													message('success',lang('success_17',true));
												} else {
													// didnt work - unexpected error
													message('error', lang('error_23',true));
												}
											} else {
												// not enough zen
												message('error', lang('error_34',true));
											}
											
										} else {
											// exceeded max stats
											message('error', lang('error_53',true));
										}
										
									} else {
										// adding command to non DL character
										message('error', lang('error_52',true));
									}
									
								} else {
									// not enough points
									message('error', lang('error_51',true));
								}
							} else {
								// need to add at least 1 point
								message('error', lang('error_54',true).config('addstats_minimum_add_points',true));
							}
					} else {
						// account is online
						message('error', lang('error_14',true));
					}
				} else {
					// character doesnt exist or does not belong to account
					message('error', lang('error_38',true));
				}
			} else {
				// unknown error (bad username or not numeric values)
				message('error', lang('error_23',true));
			}
		} else {
			// unknown error (incomplete data)
			message('error', lang('error_23',true));
		}
	}
	
	function AccountCharacter($username) {
		global $dB;
		$error = false;
		if(check_value($username)) {
			if(!Validator::UsernameLength($username)) { $error = true; }
			if(!Validator::AlphaNumeric($username)) { $error = true; }
			if(!$error) {
				$result = $dB->query_fetch_single("SELECT * FROM "._TBL_AC_." WHERE "._CLMN_AC_ID_." = '$username'");
				if(is_array($result)) {
					$characters = array();
					if(check_value($result[_CLMN_GAMEID_1_])) { $characters[] = $result[_CLMN_GAMEID_1_]; }
					if(check_value($result[_CLMN_GAMEID_2_])) { $characters[] = $result[_CLMN_GAMEID_2_]; }
					if(check_value($result[_CLMN_GAMEID_3_])) { $characters[] = $result[_CLMN_GAMEID_3_]; }
					if(check_value($result[_CLMN_GAMEID_4_])) { $characters[] = $result[_CLMN_GAMEID_4_]; }
					if(check_value($result[_CLMN_GAMEID_5_])) { $characters[] = $result[_CLMN_GAMEID_5_]; }
					if(count($characters) >= 1) {
						return $characters;
					} else {
						return null;
					}
				} else {
					return null;
				}
			} else {
				return null;
			}
		} else {
			return null;
		}
	}
	
	function CharacterData($character_name) {
		global $dB;
		if(check_value($character_name)) {
			$result = $dB->query_fetch_single(
"SELECT ch.*, CAST(ch.Inventory AS varbinary(max)) AS Inventory, st.ConnectTM, G_Name FROM dbo.Character as ch
left join dbo.MEMB_STAT as st on st.memb___id = ch.AccountID
left join dbo.GuildMember as gm on gm.Name = ch.Name
WHERE ch.Name = '$character_name'"
			    );
			if(is_array($result)) {
				return $result;
			} else {
				return null;
			}
		} else {
			return null;
		}
	}
	function getInvItems($data) {
	    if(empty($data)) return;
	    
	    $ile = 0;
	    $tmp=[];
	    foreach($data as $dump) {
	        $ile++;
	        if($ile > 8) {
	            $tmp[] = $dump;
	        }
	    }
	    return $this->getItems($tmp);
	}
	function getItems($data) {
	    if(empty($data)) return;
	    
	    $nw  = new Shop();
	    $lista = array();
	    $ile = 0;
	    foreach($data as $dump) {
	        
	        $ile++;
	        if(strlen($dump) < 32) {
	            continue;
	        }
	        
	        $item = new InvItem;
	        // [FF] FF FF FFFFFFFF FF FF FF FF FFFFFFFFFF
	        $temp = hexdec(substr($dump, 0, 2));
	        //if($temp==hexdec("FF")) continue;
	        $item->index = $temp;
	        
	        // FF [FF] FF FFFFFFFF FF FF FF FF FFFFFFFFFF
	        $temp = hexdec(substr($dump, 2, 2));
	        $item->skill = (($temp & 0x80) == 0x80);
	        $item->luck = (($temp & 0x04) == 0x04);
	        $item->level = (($temp & 0x78) >> 3);
	        $item->option = ($temp & 0x03);
	        // FF FF [FF] FFFFFFFF FF FF FF FF FFFFFFFFFF
	        $temp = hexdec(substr($dump, 4, 2));
	        $item->durability = $temp;
	        
	        // FF FF FF [FFFFFFFF] FF FF FF FF FFFFFFFFFF
	        $temp = hexdec(substr($dump, 6, 8));
	        if($item->index != 255) {
	           // $numberH = substr(md5(rand()), 0, 8);
	            $item->serial = $temp; //$temp;
	           // $dump=substr_replace($dump,$numberH,6,8);
	        }
	        
	        $temp = hexdec(substr($dump, 14, 2));
	        $item->option += ((($temp & 0x40) == 0x40) ? 4 : 0);
	        $item->excellent[0] = (($temp & 0x01) == 0x01);
	        $item->excellent[1] = (($temp & 0x02) == 0x02);
	        $item->excellent[2] = (($temp & 0x04) == 0x04);
	        $item->excellent[3] = (($temp & 0x08) == 0x08);
	        $item->excellent[4] = (($temp & 0x10) == 0x10);
	        $item->excellent[5] = (($temp & 0x20) == 0x20);
	        // FF FF FF FFFFFFFF FF [FF] FF FF FFFFFFFFFF
	        $temp = hexdec(substr($dump, 16, 2));
	        $item->ancient = $temp;
	        // FF FF FF FFFFFFFF FF FF [FF] FF FFFFFFFFFF
	        $temp = hexdec(substr($dump, 18, 2));
	        $item->type = ($temp & 0xF0) >> 4;
	        $item->levelOption = (($temp & 0x08) == 0x08);
	        // FF FF FF FFFFFFFF FF FF FF [FF] FFFFFFFFFF
	        $temp = hexdec(substr($dump, 20, 2));
	        $item->harmonyType = ($temp & 0xF0) >> 4;
	        $item->harmonyLevel = ($temp & 0x0F);
	        $item->fullhex = $dump;
	        
	        $ob = $nw->findItems($item->type, $item->index);
	        if($ob) {
	            $item->name = $ob->name;
	            $lista[]=$item;
	        }
	        
	    }
	    return $lista;
	}
	
	function CharacterBelongsToAccount($character_name,$username) {
		if(check_value($character_name) && check_value($username)) {
			if(!Validator::UsernameLength($username)) { $error = true; }
			if(!Validator::AlphaNumeric($username)) { $error = true; }
			if(!$error) {
				$characterData = $this->CharacterData($character_name);

				if(is_array($characterData)) {
					if($characterData[_CLMN_CHR_ACCID_] == $username) {
						return true;
					} else {
						return false;
					}
				} else {
					return false;
				}
			} else {
				return false;
			}
		} else {
			return false;
		}
	}
	
	function CharacterExists($character_name) {
		global $dB;
		if(check_value($character_name)) {
			$check = $dB->query_fetch_single("SELECT * FROM dbo.Character WHERE "._CLMN_CHR_NAME_." = '$character_name'");

			if(is_array($check)) {
				return true;
			} else {
				return false;
			}
		} else {
			return false;
		}
	}
	
	function DeductZEN($character_name,$zen_amount) {
		global $dB;
		if(check_value($character_name) && check_value($zen_amount) && $zen_amount >= 1 && Validator::Number($zen_amount)) {
			if($this->CharacterExists($character_name)) {
				$characterData = $this->CharacterData($character_name);
				if(is_array($characterData)) {
					if($characterData[_CLMN_CHR_ZEN_] >= $zen_amount) {
						$deduct = $dB->query("UPDATE "._TBL_CHR_." SET "._CLMN_CHR_ZEN_." = "._CLMN_CHR_ZEN_." - $zen_amount WHERE "._CLMN_CHR_NAME_." = '$character_name'");
						if($deduct) {
							return true;
						} else {
							return false;
						}
					} else {
						return false;
					}
				} else {
					return false;
				}
			} else {
				return false;
			}
		} else {
			return false;
		}
	}
	
	
	function insertItemToWebshop($chr,$id,$typ,$fulltext,$price,$time) {
	    global $dB;
	    $move = $dB->query("INSERT INTO dbo.webshop (Character, Id, Type, price, time, fulltext, starttime, endtime) VALUES ('".$chr."', ".$id.", ".$typ.", ".$price.", ".$time.", '".$fulltext."', (getdate()),(DATEADD(week,".$time.",current_timestamp)) )");
	    if($move) {
	        return true;
	    } else {
	        return false;
	    }
	}
	
	function hasRequiredLevel($level) {
		if(check_value($level) && $level >= 1) {
			if($level >= config('resets_required_level',true)) {
				return true;
			} else {
				return false;
			}
		} else {
			return false;
		}
	}
	
	function updateReset($acc,$char,$reset,$zen) {
	    global $dB;
	    if(check_value($acc)) {
	        $move = $dB->query("UPDATE "._TBL_CHR_." SET cLevel=10, MapNumber=0, MapPosX=143, MapPosY=128, Money=Money+$zen, ResetCount=ResetCount+$reset, Experience=0,Strength=5,Dexterity=5,Vitality=5,Energy=5,LevelUpPoint=(ResetCount+$reset)*1000
   WHERE "._CLMN_CHR_NAME_." = '$char' AND "._CLMN_CHR_ACCID_." = '$acc'");
	        if($move) {
	            return true;
	        } else {
	            return false;
	        }
	    } else {
	        return false;
	    }
	}
	function addMone($acc,$char,$zen) {
	    global $dB;
	    if(check_value($acc)) {
	        $move = $dB->query("UPDATE "._TBL_CHR_." SET Money=Money+$zen WHERE "._CLMN_CHR_NAME_." = '$char' AND "._CLMN_CHR_ACCID_." = '$acc'");
	        if($move) {
	            return true;
	        } else {
	            return false;
	        }
	    } else {
	        return false;
	    }
	}
	
	function addJOGtoWeb($acc,$jog) {
	    global $dB;
	    if(check_value($acc)) {
	        $move = $dB->query("UPDATE "._TBL_AC_." SET JOG=JOG+$jog WHERE "._CLMN_AC_ID_." = '$acc'");
	        if($move) {
	            return true;
	        } else {
	            return false;
	        }
	    } else {
	        return false;
	    }
	}
	
	public function updateInventory($character, $lista) {
	    global $dB;
	    $tmp ="0x";
	    foreach($lista as $i) {
	        $tmp.=$i->fullhex;
	    }
	    
	    if(check_value($character)) {
	        $move = $dB->query("UPDATE "._TBL_CHR_." SET "._CLMN_CHR_INV_."=$tmp WHERE "._CLMN_CHR_NAME_." = '$character'");
	        if($move) {
	            return true;
	        } else {
	            return false;
	        }
	    } else {
	        return false;
	    }
	}
	
	function moveCharacter($character_name,$map=0,$x=125,$y=125) {
		global $dB;
		if(check_value($character_name)) {
			$move = $dB->query("UPDATE "._TBL_CHR_." SET "._CLMN_CHR_MAP_." = $map, "._CLMN_CHR_MAP_X_." = $x, "._CLMN_CHR_MAP_Y_." = $y WHERE "._CLMN_CHR_NAME_." = '$character_name'");
			if($move) {
				return true;
			} else {
				return false;
			}
		} else {
			return false;
		}
	}
	
	function AccountCharacterIDC($username) {
		global $dB;
		if(check_value($username)) {
			if(!Validator::UsernameLength($username)) { $error = true; }
			if(!Validator::AlphaNumeric($username)) { $error = true; }
			if(!$error) {
			    $data = $dB->query_fetch_single("SELECT "._CLMN_GAMEIDC_." FROM "._TBL_AC_." WHERE "._CLMN_AC_ID_." = '$username'");
				if(is_array($data)) {
					return $data[_CLMN_GAMEIDC_];
				} else {
					return false;
				}
			} else {
				return false;
			}
		} else {
			return false;
		}
	}
	
	function GenerateCharacterClassAvatar($code=0,$alt=true,$img_tags=true) {
		global $custom;
		$image = __PATH_TEMPLATE_IMG__ . 'character-avatars/' . $custom['character_class'][$code][2];
		$name = $custom['character_class'][$code][0];
		if($img_tags) {
			if($alt) {
				return '<img class="tables-character-class-img" src="'.$image.'" title="'.$name.'" alt="'.$name.'"/>';
			} else {
				return '<img class="tables-character-class-img" src="'.$image.'" />';
			}
		} else {
			return $image;
		}
	}
	
	function getMasterLevelInfo($character_name) {
		global $dB;
		if(check_value($character_name)) {
			if($this->CharacterExists($character_name)) {
				$CharInfo = $dB->query_fetch_single("SELECT * FROM "._TBL_MASTERLVL_." WHERE "._CLMN_ML_NAME_." = '$character_name'");
				if(is_array($CharInfo)) {
					return $CharInfo;
				} else {
					return false;
				}
			} else {
				return false;
			}
		} else {
			return false;
		}
	}
	
	function hasRequiredMasterLevel($level) {
		if(check_value($level) && $level >= 1 && Validator::Number($level)) {
			if($level >= config('clearst_required_level',true)) {
				return true;
			} else {
				return false;
			}
		} else {
			return false;
		}
	}
	
	function resetMasterLevelData($character_name) {
		global $dB;
		if(check_value($character_name)) {
			if($this->CharacterExists($character_name)) {
				$reset = $dB->query("UPDATE "._TBL_MASTERLVL_." SET "._CLMN_ML_LVL_." = 0,"._CLMN_ML_EXP_." = 0,"._CLMN_ML_NEXP_." = null,"._CLMN_ML_POINT_." = 0 WHERE "._CLMN_ML_NAME_." = '$character_name'");
				if($reset) {
					return true;
				} else {
					return false;
				}
			} else {
				return false;
			}
		} else {
			return false;
		}
	}
	
	function resetMagicList($character_name) {
		global $dB;
		if(check_value($character_name)) {
		    if($this->CharacterExists($character_name)) {
				$reset = $dB->query("UPDATE "._TBL_CHR_." SET "._CLMN_CHR_MAGIC_L_." = null WHERE "._CLMN_CHR_NAME_." = '$character_name'");
				if($reset) {
					return true;
				} else {
					return false;
				}
			} else {
				return false;
			}
		} else {
			return false;
		}
	}
	
	function getCashShop($acc) {
	    global $dB;
	    return $dB->query_fetch_single("SELECT * FROM CashShopData WHERE AccountID = '$acc'");
	}
	
	/**
	 * Adds points
	 */
	function addCoinsC($acc, $points) {
	    global $dB;
	    $check = $dB->query_fetch_single("SELECT * FROM CashShopData WHERE AccountID = '$acc'");
	    
	    if(!empty($check)) {
	       return $dB->query("UPDATE CashShopData SET WCoinC = WCoinC + $points WHERE AccountID = '$acc'");
	    } else {
	       return $dB->query("INSERT INTO CashShopData (AccountID, WCoinC, WCoinP, GoblinPoint) VALUES ('".$acc."', $points, 0, 0)");
	    }
	}
}
?>