<?php

class dB {
	
	public $error;
	public $ok;
	public $dead;
	
	// Constructor --> Connect
	function __construct()
	{
		try {
			
			$pdo_connect = 'dblib:host='.__SQL_DB_HOST__.';dbname='.__SQL_DB_NAME__;
			if(check_value(__SQL_DB_PORT__)) {
				$pdo_connect .= ';port='.__SQL_DB_PORT__;
			}
			$this->db = new PDO($pdo_connect, __SQL_DB_USER__, __SQL_DB_PASS__);

			
		} catch (PDOException $e) {
			$this->dead = true;
			$this->error = "PDOException: ".$e->getMessage();
			//echo $this->error;
			if(config('error_reporting',true)) {
				die($this->error);
			} else {
				?>
				<!--  <h1>Server offline</h1>
            	<iframe id="iframa" src="/shoutbox.php?user=anonimus" scrolling="no" frameBorder="0"></iframe>
                <script>
                $(function() {
                    $('select.form-control').change(function(){
                    	$('#iframa').attr("src","/shoutbox.php?user="+$(this).val());
                	});
                });
                </script> -->
				<?
			}
		}
		
	}
	
	function connected() {
	    return $this->dead !== true;
	}
	
	
	/**
	 * query
	 * Performs sql query for statements that doesn't return data (INSERT/UPDATE/DELETE)
	 * 
	 * @param	string
	 * @return	bool
	 */
	public function query($sql, $array='')
	{
		if(!is_array($array)) $array = array($array);
		$query = $this->db->prepare($sql);
		if (!$query) {
			$this->error = $this->trow_error();
			$query->closeCursor();
			return false;
		} else {
			if($query->execute($array)) {
				$query->closeCursor();
				return true;
			} else {
				$this->error = $this->trow_error($query);
				return false;
			}
		}
	}
	
	
	/**
	 * query_fetch
	 * Performs a query + fetch in the result of an assosiative array
	 * 
	 * @param	string
	 * @return	array / null / FALSE on failure
	 */
	public function query_fetch($sql, $array='')
	{
		if(!is_array($array)) $array = array($array);
		$query = $this->db->prepare($sql);
		if (!$query) {
			$this->error = $this->trow_error();
			$query->closeCursor();
			return false;
		} else {
			if($query->execute($array)) {
				$result = $query->fetchAll(PDO::FETCH_ASSOC);
				$query->closeCursor();
				return (check_value($result)) ? $result : NULL;
			} else {
				$this->error = $this->trow_error($query);
				return false;
			}
		}
	}
	
	
	/**
	 * query_fetch_single
	 * Performs a query + fetch in the result of an assosiative array for a single record
	 * 
	 * @param	string
	 * @return	array / null / FALSE on failure
	 */
	public function query_fetch_single($sql, $array='')
	{
		$result = $this->query_fetch($sql, $array);
		return (isset($result[0])) ? $result[0] : NULL;
	}
	
	/**
	 * trow_error
	 * Returns a dB status error
	 * 
	 * @param	string
	 * @return	string
	 */
	private function trow_error($state='')
	{
		if(!check_value($state)) {
			$error = $this->db->errorInfo();
		} else {
			$error = $state->errorInfo();
		}
		return '[SQL '.$error[0].'] ['.$this->db->getAttribute(PDO::ATTR_DRIVER_NAME).' '.$error[1].'] > '.$error[2];
	}

}
?>