<?php

class Handler {

	function loadPage() {
		global $_GET,$_POST,$config,$lang,$dB,$dB2,$_SESSION,$handler,$custom,$common,$_COOKIE;

		if($this->languageExists($config['website_language'])) {
			include(__PATH_LANGUAGES__ . $config['website_language'] . '/language.php');
			if((!defined('access') or !access)) {
			    if(strpos($_REQUEST['subpage'],"ajax_") === 0 )
			         $this->loadModule($_REQUEST['page'],$_REQUEST['subpage']); 
				// blank for APIs
			} else {
				if($this->templateExists($config['website_template'])) {
					include(__PATH_TEMPLATES__ . $config['website_template'] . '/index.php');
					if(isLoggedIn() && canAccessAdminCP($_SESSION['username'])) {
						echo '<a href="'.__PATH_ADMINCP_HOME__.'" class="btn btn-danger" style="position:absolute;top:10px;right:10px;text-decoration:none;">AdminCP</a>';
					}
				} else {
					die('[WEBENGINE::ERROR][!#] Could not load template ' . $config['website_template']);
				}
			}
		} else {
			die('[WEBENGINE::ERROR][!#] Could not load language: ' . $config['website_language']);
		}
	}

	function loadModule($page = 'news',$subpage = 'home') {
		global $_GET,$_POST,$config,$lang,$dB,$dB2,$_SESSION,$custom,$common,$_COOKIE;
	
		if(!check_value($page)) { $page = 'news'; }
		if(!check_value($subpage)) { $subpage = 'home'; }
		
		if($this->moduleExists($page)) {
			if($page == 'usercp') {
				if($this->usercpmoduleExists($subpage)) {
					include(__PATH_MODULES__ .  'usercp.php');
					include(__PATH_MODULES_USERCP__ . $subpage . '.php');
				} else {
					redirect(1,'usercp/');
				}
			} else {
				include(__PATH_MODULES__ . $page . '.php');
			}
		} else {
			redirect();
		}
	
	}

	function moduleExists($page) {
		if(file_exists(__PATH_MODULES__ . $page . '.php')) {
			return true;
		} else {
			return false;
		}
	}
	
	function usercpmoduleExists($page) {
		if(file_exists(__PATH_MODULES_USERCP__ . $page . '.php')) {
			return true;
		} else {
			return false;
		}
	}
	
	function templateExists($template) {
		if(file_exists(__PATH_TEMPLATES__ . $template . '/index.php')) {
			return true;
		} else {
			return false;
		}
	}
	
	function languageExists($language) {
		if(file_exists(__PATH_LANGUAGES__ . $language . '/language.php')) {
			return true;
		} else {
			return false;
		}
	}
	
	function admincpmoduleExists($page) {
		if(file_exists(__PATH_ADMINCP_MODULES__ . $page . '.php')) {
			return true;
		} else {
			return false;
		}
	}
	
	function isAdminCPModuleRestricted($module,$user) {
		$admincp_modules_restriction = config('admincp_modules_restriction',true);
		if(array_key_exists($module,$admincp_modules_restriction)) {
			$allowed_users = explode(",",$admincp_modules_restriction[$module]);
			if(in_array($user,$allowed_users)) {
				return false;
			} else {
				return true;
			}
		} else {
			return false;
		}
	}
	
	function loadAdminCPModule($module='home') {
		global $dB,$dB2,$config,$custom,$_SESSION,$_POST,$_REQUEST,$_GET,$common,$handler;
		if(!check_value($module)) { $module = 'home'; }
		if($this->admincpmoduleExists($module)) {
			if(!$this->isAdminCPModuleRestricted($module,$_SESSION['username'])) {
				include(__PATH_ADMINCP_MODULES__.$module.'.php');
			} else {
				message('error','You do not have access to this module.');
			}
		} else {
			message('error','INVALID MODULE');
		}
	}
	function webenginePowered(){
	    
	}

}
?>