<?php

class login {

	function isLoggedIN() {
		global $_SESSION;
		if($_SESSION['valid'] == true) {
			if(check_value($_SESSION['userid']) && check_value($_SESSION['username'])) {
				if(config('enable_session_timeout',true)) {
					if($this->isSessionActive($_SESSION['timeout'])) {
						$_SESSION['timeout'] = time();
						return true;
					} else {
						$this->logout();
						return false;
					}
				} else {
					return true;
				}
			} else {
				return false;
			}
		}
	}
	
	function validateLogin($username,$password) {
		global $common,$_SERVER;
		if(check_value($username) && check_value($password)) {
			if($this->canLogin($username)) {
				if($common->userExists($username)) {
					if($common->validateUser($username,$password)) {
					
						$this->removeFailedLogins($username);
						session_regenerate_id();
						$_SESSION['valid'] = true;
						$_SESSION['timeout'] = time();
						$_SESSION['userid'] = $common->retrieveUserID($username);
						$_SESSION['username'] = $username;
						redirect(1,'usercp/');
						
					} else {
						// invalid password
						$this->addFailedLogin($username,$_SERVER['REMOTE_ADDR']);
						message('error', lang('error_1',true));
						message('warning', $this->checkFailedLogins($username) . lang('warning_1b',true) . config('max_login_attempts',true), lang('warning_1a',true));
					}
				} else {
					// invalid username
					message('error', lang('error_2',true));
				}
			} else {
				// user is timed out
				message('error', lang('error_3',true));
			}
		} else {
			// user didn't complete a field
			message('error', lang('error_4',true));
		}
	}
	
	function canLogin($username) {
		global $dB,$common;
		if(!Validator::UsernameLength($username)) { $error = true; }
		if(!Validator::AlphaNumeric($username)) { $error = true; }
		if(!$error) {
			$fl = $this->checkFailedLogins($username);
			if($fl >= config('max_login_attempts',true)) {
				$result = $dB->query_fetch_single("SELECT * FROM "._TBL_FLA_." WHERE username = '$username'");
				if(is_array($result)) {
					if(time() > $result['unlock_timestamp']) {
						$this->removeFailedLogins($username);
						return true;
					} else {
						return false;
					}
				} else {
					return true;
				}
			} else {
				return true;
			}
		
		}
	}
	
	function checkFailedLogins($username) {
		global $dB;
		if(!Validator::UsernameLength($username)) { $error = true; }
		if(!Validator::AlphaNumeric($username)) { $error = true; }
		if(!$error) {
			$result = $dB->query_fetch_single("SELECT * FROM "._TBL_FLA_." WHERE username = '$username'");
			if(is_array($result)) {
				return $result['failed_attempts'];
			} else {
				return false;
			}
		}
	}
	
	function addFailedLogin($username,$ipaddress) {
		global $dB,$common,$config;
		if(!Validator::UsernameLength($username)) { $error = true; }
		if(!Validator::AlphaNumeric($username)) { $error = true; }
		if(!Validator::Ip($ipaddress)) { $error = true; }
		if(!$common->userExists($username)) { $error = true; }
		if(!$error) {
		
			$n = $this->checkFailedLogins($username);
			$timeout = time() + config('failed_login_timeout',true) * 60;
			
			if(!$n) {
				$data = array($username, $ipaddress, 0, 1);
				$dB->query("INSERT INTO "._TBL_FLA_." (username, ip_address, unlock_timestamp, failed_attempts) VALUES (?, ?, ?, ?)", $data);
			} else {
			
				$new_n = $n + 1;
				
				if($new_n >= 5) {
					$dB->query("UPDATE "._TBL_FLA_." SET ip_address = '$ipaddress', failed_attempts = '$new_n', unlock_timestamp = '$timeout' WHERE username = '$username'");
				} else {
					$dB->query("UPDATE "._TBL_FLA_." SET ip_address = '$ipaddress', failed_attempts = '$new_n' WHERE username = '$username'");
				}
			}
		}
	
	}
	
	function removeFailedLogins($username) {
		global $dB;
		if(!Validator::UsernameLength($username)) { $error = true; }
		if(!Validator::AlphaNumeric($username)) { $error = true; }
		if(!$error) {
			$dB->query("DELETE FROM "._TBL_FLA_." WHERE username = '$username'");
		}
	}
	
	function isSessionActive($session_timeout) {
		if(check_value($session_timeout)) {
			$offset = time() - $session_timeout;
			if($offset < config('session_timeout',true)) {
				return true;
			} else {
				return false;
			}
		} else {
			return false;
		}
	}
	
	function logout() {
		$_SESSION = array();
		session_destroy();
		redirect();
	}

}
?>