<?php

class News {

	function addNews($title,$content,$author='Administrator',$comments=1) {
		global $dB;
		if(check_value($title) && check_value($content) && check_value($author)) {
			if($this->checkTitle($title)) {
				if($this->checkContent($content)) {
					// make sure comments is 1 or 0
					if($comments < 0 || $comments > 1) {
						$comments = 1;
					}
				
					// collect data
					$news_data = array(
						$title,
						$author,
						time(),
						$content,
						$comments
					);
					// add news
					$add_news = $dB->query("INSERT INTO "._TBL_NEWS_." (news_title,news_author,news_date,news_content,allow_comments) VALUES (?,?,?,?,?)", $news_data);

					if($add_news) {
						// success message
						message('success', lang('success_15',true));
					} else {
						message('error', lang('error_23',true));
					}
					
				} else {
					message('error', lang('error_43',true));
				}
			} else {
				message('error', lang('error_42',true));
			}
		} else {
			message('error', lang('error_41',true));
		}
	}
	
	function removeNews($id) {
		global $dB;
		if(Validator::Number($id)) {
			if($this->newsIdExists($id)) {
				$remove = $dB->query("DELETE FROM "._TBL_NEWS_." WHERE news_id = '$id'");
				if($remove) {
					return true;
				} else {
					return false;
				}
			} else {
				return false;
			}
		} else {
			return false;
		}
	}
	
	function getNews($id) {
	    global $dB,$dB2;
	    
	    if(Validator::Number($id)) {
	      $edit = "select * FROM "._TBL_NEWS_." WHERE news_id = '$id'";
	      if($edit) {
	          return  $dB->query_fetch($edit);
	      } else {
	          return false;
	      }
	    } else {
	        return false;
	    }
	    
	}
	
	function editNews($id,$title,$content,$author) {
		global $dB;
		if(Validator::Number($id)) {
			if(Validator::AlphaNumeric($author)) {
				if($this->checkTitle($title) && $this->checkContent($content)) {
					$edit = $dB->query("UPDATE "._TBL_NEWS_." SET news_title = '$title', news_content = '$content', news_author = '$author' WHERE news_id = '$id'");
					if($edit) {
						return true;
					} else {
						return false;
					}
				} else {
					return false;
				}
			} else {
				return false;
			}
		} else {
			return false;
		}
	}
	
	function updateNews() {
	
	}
	
	function checkTitle($title) {
		if(check_value($title)) {
			if(strlen($title) < 4 || strlen($title) > 80) {
				return false;
			} else {
				return true;
			}
		} else {
			return false;
		}
	}
	
	function checkContent($content) {
		if(check_value($content)) {
			if(strlen($content) < 4) {
				return false;
			} else {
				return true;
			}
		} else {
			return false;
		}
	}
	
	function retrieveNews() {
		global $dB;
		$news = $dB->query_fetch("SELECT * FROM "._TBL_NEWS_." ORDER BY news_id DESC");
		if(is_array($news)) {
			return $news;
		} else {
			return null;
		}
	}
	
	function newsIdExists($id) {
		global $dB;
		if(Validator::Number($id)) {
			$id_exists = $dB->query_fetch_single("SELECT * FROM "._TBL_NEWS_." WHERE news_id = '$id'");
			if(is_array($id_exists)) {
				return true;
			} else {
				return false;
			}
		} else {
			return false;
		}
	}
	
	function deleteNewsFiles() {
		$files = glob(__PATH_NEWS_CACHE__.'*');
		foreach($files as $file) {
			if(is_file($file)) {
				unlink($file);
			}
		}
	}
	
	function cacheNews() {
		if($this->isNewsDirWritable()) {
			$news_list = $this->retrieveNews();
			if(is_array($news_list)) {
				$this->deleteNewsFiles();
				foreach($news_list as $news) {
					$handle = fopen(__PATH_NEWS_CACHE__."news_".$news['news_id'].".cache", "a");
					fwrite($handle, $news['news_content']);
					fclose($handle);
				}
				return true;
			} else {
				return false;
			}
		} else {
			return false;
		}
	}
	
	function isNewsDirWritable() {
		if(is_writable(__PATH_NEWS_CACHE__)) {
			return true;
		} else {
			return false;
		}
	}
	
	function retrieveNewsDataForCache() {
		global $dB;
		$news = $dB->query_fetch("SELECT news_id,news_title,news_author,news_date,allow_comments FROM "._TBL_NEWS_." ORDER BY news_id DESC");
		if(is_array($news)) {
			return $news;
		} else {
			return null;
		}
	}
	
	function updateNewsCacheIndex() {
		$news_list = $this->retrieveNewsDataForCache();
		$cacheDATA = BuildCacheData($news_list);
		$updateCache = UpdateCache('news.cache',$cacheDATA);
		if($updateCache) {
			return true;
		} else {
			return false;
		}
	}
	
	function LoadCachedNews($id) {
		if(Validator::Number($id)) {
			if($this->newsIdExists($id)) {
				$file = __PATH_NEWS_CACHE__ . 'news_' . $id . '.cache';
				if(file_exists($file) && is_readable($file)) {
					return file_get_contents($file);
				} else {
					return false;
				}
			} else {
				return false;
			}
		} else {
			return false;
		}
	}

}
?>