<?php

class Rankings {

    function GetResults($limit=10,$order=null,$direction="DESC",$select="*",$where="",$table=_TBL_CHR_,$group=null,$usedb2=false) {
		global $dB,$dB2;
		if(!empty($where)) $where =" WHERE ".$where;
		if(Validator::Number($limit)) {
			$build_query = "SELECT TOP $limit $select FROM $table $where ";
			if(check_value($group)) {
				$build_query .= "GROUP BY $group ";
			}
			if(check_value($order)) {
				$build_query .= "ORDER BY $order $direction";
			}
			if(config('SQL_USE_2_DB',true)) {
				if($usedb2) {
					$result = $dB2->query_fetch($build_query);
				} else {
					$result = $dB->query_fetch($build_query);
				}
			} else {
				$result = $dB->query_fetch($build_query);
			}
			if(is_array($result)) {
				return $result;
			} else {
				return null;
			}
		} else {
			return null;
		}
	}
	
	function UpdateRankingCache($ranking_type) {
		global $config;
		switch($ranking_type) {
			case 'level':
				$dbDATA = $this->GetResults(config('rankings_results',true),'cLevel','DESC','Name,Class,cLevel'," cLevel<400");
				$cacheDATA = BuildCacheData($dbDATA);
				UpdateCache('rankings_level.cache',$cacheDATA);
			break;
			case 'resets':
				$dbDATA = $this->GetResults(config('rankings_results',true),'ResetCount','DESC','Name,Class,ResetCount',"");

				$cacheDATA = BuildCacheData($dbDATA);
				UpdateCache('rankings_resets.cache',$cacheDATA);
			break;
			case 'killers':
				$dbDATA = $this->GetResults(config('rankings_results',true),'Kills','DESC','Name,Class,Kills');
				$cacheDATA = BuildCacheData($dbDATA);
				UpdateCache('rankings_pk.cache',$cacheDATA);
			break;
			case 'grandresets':
				$dbDATA = $this->GetResults(config('rankings_results',true),'Grand_Resets','DESC','Name,Class,Grand_Resets');
				$cacheDATA = BuildCacheData($dbDATA);
				UpdateCache('rankings_gr.cache',$cacheDATA);
			break;
			case 'online':
				$Character = new Character();
				$dbDATA = $this->GetResults(config('rankings_results',true),'OnlineDuration','DESC','AccountId,OnlineDuration as TotalOnlineTime',"",_TBL_LOGEX_,null,true);
				foreach($dbDATA as $thisData) {
					$thisData['AccountId'] = $Character->AccountCharacterIDC($thisData['AccountId']);
					if(!empty($thisData['AccountId']))
					$newDATA[] = array($thisData['AccountId'],$thisData['TotalOnlineTime']);
				}
				$cacheDATA = BuildCacheData($newDATA);
				UpdateCache('rankings_online.cache',$cacheDATA);
			break;
			case 'votes':
			break;
			case 'guilds':
				$dbDATA = $this->GetResults(config('rankings_results',true),'G_Score','DESC','G_Name,G_Master,G_Score,G_Mark',"",'Guild');
				$cacheDATA = BuildCacheData($dbDATA);
				UpdateCache('rankings_guilds.cache',$cacheDATA);
			break;
			case 'bc':
			    $dbDATA = $this->GetResults(config('rankings_results',true),'Score','DESC','*',"",'RankingBloodCastle');
			    $cacheDATA = BuildCacheData($dbDATA);
			    UpdateCache('rankings_bc.cache', $cacheDATA);
			    break;
			default:
			break;
		}
	}
	
	function GuildLogo($code,$xy=3) {
		// Convert HEX -> DEC
		$code = urlencode(bin2hex($code));
		$color[0] = '';
		$color[1] = '#000000';
		$color[2] = '#8c8a8d';
		$color[3] = '#ffffff';
		$color[4] = '#fe0000';
		$color[5] = '#ff8a00';
		$color[6] = '#ffff00';
		$color[7] = '#8cff01';
		$color[8] = '#00ff00';
		$color[9] = '#01ff8d';
		$color['a'] = '#00ffff';
		$color['b'] = '#008aff';
		$color['c'] = '#0000fe';
		$color['d'] = '#8c00ff';
		$color['e'] = '#ff00fe';
		$color['f'] = '#ff008c'; 
		// Default Position ZERO
		$i = 0; 
		$ii = 0;
		// Create Table
		$it = '<table style=\'width: '.(8*$xy).'px;height:'.(8*$xy).'px\' border=0 cellpadding=0 cellspacing=0><tr>';
		while ($i<64) {
			$place  = $code{$i};
			$i++;
			$ii++;
			$add = $color[$place];
			$it .= '<td class=\'guildlogo\' style=\'background-color: '.$add.';\' width=\''.$xy.'\' height=\''.$xy.'\'></td>';
			if ($ii==8) { 
				$it .=  '</tr>'; 
				if ($ii != 64) $it .= '<tr>';
				$ii = 0; 
			}
		}
		$it .= '</table>';
		return $it;
	}

}

?>