<?php

class Reset {
    public function GetNotActiveAccounts() {
        global $dB;
        $build_query = "
        SELECT 
            ch.AccountID,
            ch.Name,
            ch.ResetCount,
            DATEDIFF(DAY, st.ConnectTM, GETDATE()) as DayDiff
        FROM 
            dbo.Character as ch
            left join dbo.MEMB_STAT as st on st.memb___id = ch.AccountID
        WHERE
            ch.ResetCount > 0 AND
            DATEDIFF(DAY, st.ConnectTM, GETDATE()) > 14
        ORDER BY ch.ResetCount DESC
        ";
        return $dB->query_fetch($build_query);
    }
    
    public function DowngradeOldChars() {
        global $dB;
        $build_query = "
         UPDATE 
			[MuOnline].[dbo].[Character]
         SET
              ResetCount = ResetCount - 1,
              Strength = CEILING(ResetCount*400*5)/4,
              Dexterity = CEILING(ResetCount*400*5)/4,
              Vitality = CEILING(ResetCount*400*5)/4,
              Energy = CEILING(ResetCount*400*5)/4

         FROM [MuOnline].[dbo].[Character] AS ch
         LEFT join  [MuOnline].[dbo].[MEMB_STAT] AS st ON st.memb___id = ch.AccountID
         WHERE
            ch.ResetCount > 5 AND
            DATEDIFF(DAY, st.ConnectTM, GETDATE()) > 14
        ";
        return $dB->query_fetch($build_query);
    }
}

?>