<?php
class Item {
    public $type;
    public $index;
    
    public $name;
    
    function __construct($name, $type, $index) {
        $this->name = $name;
        $this->type = $type;
        $this->index = $index;
    }
    
}


class InvItem {
    
    public $index;
    public $type;
    public $name;
    public $skill;
    public $luck;
    public $level;
    public $durability;
    public $serial;
    public $option;
    public $excellent;
    public $ancient;
    public $levelOption;
    public $harmonyType;
    public $harmonyLevel;
    public $fullhex;
    
    function __construct() {
        
    }
    
    private function isExcellent() {
        foreach($this->excellent as $i) {
            if($i == 1) return true;
        }
        
        return false;
    }
    
    public function itemTip() {
        $name = "";
        if($this->type == 14) {
            $name = $this->name;
            if($this->level>0)
                $name .= " +".$this->level;
        } else {
            $name .= $this->name;
            if($this->level>0)
                $name .= " +".$this->level;
                
            if($this->luck)
                $name .= " +Luck";
        
            if($this->option)
                $name .= " +".($this->option*4)."o";
            
            if($this->skill)
                $name .= " +Skill";
            
            if($this->ancient) $name = "<span class='ant'>". $name ."</span>";
                else
            if($this->isExcellent()) {
                        $name = "<span class='exe'>Excellent ". $name ."</span>";
                }
        }
        
        return $name;
    }
    
    public function itemName() {
        
        $name = "";
        if($this->type == 14) {
            $name = $this->name;
            
            if($this->level>0)
                $name .= " +".$this->level;
        } else {
            $name .= $this->name;
            
            if($this->level>0)
                $name .= " +".$this->level;
            
            if($this->luck)
                $name .= " +Luck";
            
            if($this->option)
                $name .= " +".($this->option*4)."o";

            if($this->skill)  
                $name .= " +Skill";
                
            if($this->ancient) $name = "<span class='ant'>". $name ."</span>";
                else    
            if($this->isExcellent()) $name = "<span class='exe'>Excellent ". $name ."</span>";
            
        }
        
        
        return $name;
    }
}

class Shop {
    private $itemsData = [];
    
    function __construct() {
        global $config;
        $type = 0;
        
        foreach(file($config['url']."/includes/classes/Item.txt") as $line) {
            if($this->skipLine($line)) {
                continue;
            } 
            
            $tmp = array_values(array_filter(explode(" ",$line)));
            
            if(count($tmp)>1) {
                $name = $this->getItemName($line);
                $this->itemsData[] = new Item($name,$type,$tmp[0]);
            } else {
                $type = $tmp[0];
            }
        }
    }
    
    public function findItems($type, $index) {
        foreach($this->itemsData as $item) {
            if($item->type == $type && $item->index == $index ) {
                return $item;
            }
        }
        return null;
    }
    
    private function skipLine($line) {
        $pos = strpos($line, '//');
        return ($pos !== false);
    }
    
    private function getItemName($string) {
        if(empty($string)) {
            return "";
        }
        
        preg_match('/"([^"]+)"/', $string, $m);
        return $m && $m[1] ? $m[1] : "";
    }
    
}

