<?php

class Vip {
	
	function VipProcess($userid,$plan) {
		global $common;
		$plan = Decode($plan);
		if(check_value($userid) && Validator::Number($userid) && check_value($plan) && Validator::Number($plan)) {
			$planData = $this->PlanInfo($plan);
			$userData = $common->accountInformation($userid);
			if(is_array($userData) && is_array($planData)) {
			
				// data
				$username = $userData[_CLMN_USERNM_];
				$vipstamp = $userData[_CLMN_VIP_STAMP_];
				$plandays = $planData[0];
				$plandiscount = $planData[1];
				$planprice = $this->CalculatePlanCost($plandays,$plandiscount);
				
				if(!$common->accountOnline($username)) {
					// deduct credits
					$deduct = $common->substractCredits($userid,$planprice);
					if($deduct) {
						if($this->isVIP($userid)) {
							// Extend Timestamp
							$new_timestamp = $this->CalculateExtension($vipstamp,$plandays);
							$update = $common->updateVipTimeStamp($userid,$new_timestamp);
							if($update) {
								// success
								message('success', lang('success_13',true));
							} else {
								// unkown error
								message('error', lang('error_23',true));
							}
						} else {
							// New timestamp
							$new_timestamp = $this->CalculateTimestamp($plandays);
							
							if(config('vip_enable_promotion',true)) {
								if($this->vipGetsPromotion()) {
									$plandays = $this->addPromotionDays($new_timestamp);
									$gotFreeDays = true;
								} else {
									$gotFreeDays = false;
								}
							}
							
							$update = $common->updateVipTimeStamp($userid,$new_timestamp);
							if($update) {
								// success
								message('success', lang('success_14',true));
								
								if($gotFreeDays) {
									message('success', lang('vip_reward_1b',true).config('vip_promotion_reward_days',true).lang('vip_reward_1c',true), lang('vip_reward_1a',true));
								}
							} else {
								// unkown error
								message('error', lang('error_23',true));
							}
						}
					} else {
						// not enough credits
						message('error', lang('error_40',true));
					}
				} else {
					// account is online
					message('error', lang('error_14',true));
				}
			} else {
				// invalid user (unknown error)
				message('error', lang('error_23',true));
			}
		} else {
			// missing data (unknown error)
			message('error', lang('error_23',true));
		}
	}
	
	function PackageExists($id) {
		if(check_value($id) && Validator::Number($id)) {
			$VipPlans = config('vip_plans',true);
			if(is_array($VipPlans[$id])) {
				return true;
			} else {
				return false;
			}
		} else {
			return false;
		}
	}
	
	function PlanInfo($id) {
		if(check_value($id) && $this->PackageExists($id)) {
			$VipPlans = config('vip_plans',true);
			return $VipPlans[$id];
		} else {
			return null;
		}
	}
	
	function CalculateTimestamp($days) {
		if(check_value($days) && Validator::Number($days) && $days >= 1) {
			$vip_days = 60*60*24*$days;
			$free_time = 3600;
			$result = time() + $free_time + $vip_days;
			return $result;
		} else {
			return null;
		}
	}
	
	function CalculateExtension($timestamp,$days) {
		if(check_value($timestamp) && check_value($days) && Validator::Number($days) && $days >= 1) {
			$vip_days = 60*60*24*$days;
			$result = $timestamp + $vip_days;
			return $result;
		} else {
			return null;
		}
	}
	
	function isVIP($userid) {
		global $common;
		if(check_value($userid) && Validator::Number($userid)) {
			$accountInfo = $common->accountInformation($userid);
			if($accountInfo) {
				$vipTimestamp = $accountInfo[_CLMN_VIP_STAMP_];
				if($vipTimestamp > time()) {
					return true;
				} else {
					return false;
				}
			} else {
				return false;
			}
		} else {
			return false;
		}
	}
	
	function RemainingVIP($timestamp) {
		if(check_value($timestamp) && Validator::Number($timestamp)) {
			$calculate = ($timestamp - time()) / (60*60*24);
			return round($calculate);
		} else {
			return false;
		}
	}
	
	function vipGetsPromotion() {
		$success_rate = config('vip_promotion_success_percent',true);
		$random = rand(1,100);
		if($random <= $success_rate) {
			return true;
		} else {
			return false;
		}
	}
	
	function addPromotionDays($timestamp) {
		if(check_value($timestamp) && Validator::Number($timestamp)) {
			$promotion_days = 60*60*24*config('vip_promotion_reward_days',true);
			return $timestamp+$promotion_days;
		} else {
			return false;
		}
	}
	
	function CalculatePlanCost($days,$discount=0) {
		if(check_value($days) && Validator::Number($days)) {
			$vip_day_cost = config('vip_day_cost',true);
			$calculate_days_cost = round($days*$vip_day_cost);
			if($discount >= 1) {
				// Formula: original price - ( (discount % / 100) * original price )
				$discounted_price = $calculate_days_cost - (($discount/100)*$calculate_days_cost);
				return round($discounted_price);
			} else {
				return round($calculate_days_cost);
			}
		} else {
			return false;
		}
	}

}
?>