<?php

class Vote {

	function voteProcess($userid,$userip,$votesiteid) {
		global $common;
		if(check_value($userid) && check_value($userip) && check_value($votesiteid)) {
			if(!Validator::Number($votesiteid)) { $error = true; }
			if(!Validator::Number($userid)) { $error = true; }
			if(!Validator::Ip($userip)) { $error = true; }
			if(!$error) {
				if($this->siteExists($votesiteid)) {
					if($this->canUserVote($userid,$votesiteid)) {
						if($this->canIPVote($userip,$votesiteid)) {
							
							// Add Record
							$add = $this->addRecord($userid,$userip,$votesiteid);
							
							if($add) {
								$voteSite = config('vote_sites',true);
								$voteLink = $voteSite[$votesiteid][2];
								
								// Give Reward
								$reward = $common->addCredits($userid, $voteSite[$votesiteid][1]);
								
								// Log Vote
								if(config('vote_save_logs',true)) {
									$this->logVote($votesiteid,$userid);
								}
								
								// Redirect
								redirect(3, $voteLink);
								
							} else {
								// unknown error
								message('error', lang('error_23',true));
							}
							
						} else {
							// ip already voted
							message('error', lang('error_16',true));
						}
					} else {
						// user id already voted
						message('error', lang('error_15',true));
					}
				} else {
					// vote site doesnt exist
					message('error', lang('error_23',true));
				}
			} else {
				// unknown error
				message('error', lang('error_23',true));
			}
		
		} else {
			// unknown error
			message('error', lang('error_23',true));
		}
	}

	function canUserVote($userid,$votesiteid) {
		global $dB;
		if(!Validator::Number($votesiteid)) { $error = true; }
		if(!Validator::Number($userid)) { $error = true; }
		
		if(!$error) {
			$check = $dB->query_fetch_single("SELECT * FROM "._TBL_VOTES_." WHERE user_id = '$userid' AND vote_site_id = '$votesiteid'");
			if(is_array($check)) {
				if($this->timePassed($check['timestamp'])) {
					$remove = $this->removeRecord($check['id']);
					if($remove) {
						return true;
					} else {
						return false;
					}
				} else {
					return false;
				}
			} else {
				return true;
			}
		} else {
			return false;
		}
	}
	
	function canIPVote($ip,$votesiteid) {
		global $dB;
		if(!Validator::Number($votesiteid)) { $error = true; }
		if(!Validator::Ip($ip)) { $error = true; }
		
		if(!$error) {
			$check = $dB->query_fetch_single("SELECT * FROM "._TBL_VOTES_." WHERE user_ip = '$ip' AND vote_site_id = '$votesiteid'");
			if(is_array($check)) {
				if($this->timePassed($check['timestamp'])) {
					$remove = $this->removeRecord($check['id']);
					if($remove) {
						return true;
					} else {
						return false;
					}
				} else {
					return false;
				}
			} else {
				return true;
			}
		} else {
			return false;
		}
	}
	
	function addRecord($userid,$userip,$votesiteid) {
		global $dB,$common;
		if(!Validator::Number($userid)) { $error = true; }
		if(!Validator::Number($votesiteid)) { $error = true; }
		if(!Validator::Ip($userip)) { $error = true; }
		
		if(!$error) {
			if(is_array($common->accountInformation($userid))) {
				if($this->siteExists($votesiteid)) {
					$voteSiteInfo = config('vote_sites',true);
					$timestamp = time() + $voteSiteInfo[1][4]*60*60;
					$data = array(
						$userid,
						$userip,
						$votesiteid,
						$timestamp
					);
					$add = $dB->query("INSERT INTO "._TBL_VOTES_." (user_id, user_ip, vote_site_id, timestamp) VALUES (?, ?, ?, ?)", $data);
					
					if($add) {
						return true;
					} else {
						return false;
					}
				}
			} else {
				return false;
			}
		} else {
			return false;
		}
	}
	
	function removeRecord($id) {
		global $dB;
		if(Validator::Number($id)) {
			$dB->query("DELETE FROM "._TBL_VOTES_." WHERE id = '$id'");
			return true;
		} else {
			return false;
		}
	}
	
	function timePassed($timestamp) {
		if(Validator::Number($timestamp)) {
			if(time() > $timestamp) {
				return true;
			} else {
				return false;
			}
		} else {
			return false;
		}
	}
	
	function siteExists($id) {
		if(Validator::Number($id)) {
			$vote_sites = config('vote_sites',true);
			if(is_array($vote_sites[$id])) {
				return true;
			} else {
				return false;
			}
		} else {
			return false;
		}
	}
	
	function logVote($site_id,$user_id) {
		global $dB;
		if(Validator::Number($site_id) && Validator::Number($user_id)) {
			$add_data = array(
				$user_id,
				$site_id,
				time()
			);
			$add_log = $dB->query("INSERT INTO "._TBL_VOTE_LOGS_." (user_id,votesite_id,timestamp) VALUES (?,?,?)", $add_data);
			if($add_log) {
				return true;
			} else {
				return false;
			}
		} else {
			return false;
		}
	}

}
?>