<?php
/* --------------------------------------------------------------------

  WebEngine
  http://lautaroangelico.com/webengine/
  @version	1.0.3
  @author	Lautaro Angélico <http://lautaroangelico.com/>
			<angelico.lautaro@gmail.com>

  Copyright (C) 2012-2013 Lautaro Angélico All rights reserved.
  --------------------------------------------------------------------- */

// GENERAL SETTINGS
$config['system_active']    = true;
$config['error_reporting']  = false;
$config['website_template'] = 'redzone';
$config['website_language'] = 'en';
$config['encryption_hash']  = 'ksdunfgc3n'; // one time setting
$config['maintenance_page'] = 'http://bloodmu.pl/';
$config['add_credits_to_temp'] = true; // if false, adding credits will edit the cspoints column! (RECOMMENDED: TRUE)

// USERS WITH ADMINCP ACCESS
$config['admincp_users_access'] = array(
	'rafal',
);
// RESTRICT ADMINCP MODULES TO CERTAIN USERS
$config['admincp_modules_restriction'] = array(
	'latestpaypal' => 'rafal',
	'latestsr' => 'rafal',
);

// WEBSITE TITLE
$config['website_title'] = 'BloodMu.org - prywatny serwer Mu';
$config['website_footer_copyright'] = 'Copyright &copy;2020';
$config['website_meta_description'] = 'BloodMu - polski prywatny server MuOnline S6.3 ';
$config['website_meta_keywords'] = 'muonline, season6, mu, private, mmorpg, best, server polska';
$config['website_forum_link'] = 'http://forum.muonline.com/';

// SQL DATA
$config['SQL_DB_HOST'] = '77.91.6.18';
$config['SQL_DB_NAME'] = 'MuOnline';
$config['SQL_DB_2_NAME'] = 'MuOnline_s6';
$config['SQL_DB_USER'] = 'bloodmu';
$config['SQL_DB_PASS'] = '';
$config['SQL_DB_PORT'] = '1433';
$config['SQL_USE_2_DB'] = false;

// EMAIL SYSTEM
$config['email_system_active'] = true;
$config['email_send_from'] = 'admin@recone.org';
$config['email_send_from_name'] = 'BloodMu.pl';
$config['email_titles'] = array(
	// email template => title
	'CHANGE_PASSWORD' => 'MU Password Updated!',
	'CHANGE_PASSWORD_EMAIL_VERIFICATION' => 'MU Password Change Request',
	'PASSWORD_RECOVERY_REQUEST' => 'MU Password Recovery Request',
	'PASSWORD_RECOVERY_COMPLETED' => 'Your New MU Password',
	'MASTER_KEY_RECOVERY' => 'Your MU Master Key',
);

// NEWS SYSTEM
$config['news_expanded'] = 3;
$config['news_list_limit'] = 20;
$config['news_enable_comment_system'] = false; // DISQUS
$config['news_disqus_shortname'] = 'mu';

// REGISTRATION SYSTEM CONFIGS
$config['register_enable'] = true;
$config['register_enable_recaptcha'] = false;
$config['register_recaptcha_public_key'] = '';
$config['register_recaptcha_private_key'] = '';

// LOGIN SYSTEM CONFIGS
$config['enable_session_timeout'] = true;
$config['session_timeout'] = 300; // seconds
$config['max_login_attempts'] = 5; // minutes
$config['failed_login_timeout'] = 5; // minutes

// VOTE SYSTEM CONFIGS
$config['vote_enable'] = true;
$config['vote_save_logs'] = true;
$config['vote_credit_system'] = 1; // 1=cspoints | 2=pcpoints // [NOT ACTIVE]
$config['vote_sites'] = array(
	// ID | Name | Credits Reward | IN Link | OUT Link | Wait Hours
	1 => array('XtremeTop100', 30, 'IN-LINK', 'OUT-LINK', 5)
);

// MYACCOUNT MODULE SETTINGS
$config['myaccount_enable'] = true;

// RESET CHARACTER CONFIGS
$config['resets_enable'] = true;
$config['resets_enable_zen_requirement'] = true;
$config['resets_price_zen'] = 100000000;
$config['resets_required_level'] = 400;
$config['resets_enable_credit_reward'] = false;
$config['resets_credits_reward'] = 1;

// CLEARPK CHARACTER SETTINGS
$config['clearpk_enable'] = true;
$config['clearpk_enable_zen_requirement'] = true;
$config['clearpk_price_zen'] = 100000000;

// UNSTUCK CHARACTER SETTINGS
$config['unstuck_enable'] = true;
$config['unstuck_enable_zen_requirement'] = true;
$config['unstuck_price_zen'] = 1000000;

// RESET STATS SETTINGS
$config['resetstats_enable'] = true;
$config['resetstats_enable_zen_requirement'] = true;
$config['resetstats_price_zen'] = 100000000;
$config['resetstats_new_stats'] = 25;

// CLEAR SKILL-TREE SETTINGS
$config['clearst_enable'] = true;
$config['clearst_enable_zen_requirement'] = true;
$config['clearst_price_zen'] = 1000000;
$config['clearst_required_level'] = 200;
$config['clearst_reset_method'] = 1; // 1=reset level and stats | 2=reset stats only(give points back) [NOT ACTIVE - METHOD 1 ONLY]

// VIP MEMBERSHIP SETTINGS
$config['vip_enable'] = false;
$config['vip_enable_promotion'] = false;
$config['vip_promotion_success_percent'] = 80; // n/100
$config['vip_promotion_reward_days'] = 1;
$config['vip_day_cost'] = 50;
$config['vip_plans'] = array(
	//	Days | Discount Percent
	1 => array(7,0),
	2 => array(30,0),
	3 => array(60,10)
);
$config['vip_show_benefits'] = true;
$config['vip_benefits'] = array(
	'+80% Experience',
	'+90% Excellent Items Drop',
	'+1 Excellent Item Option Drop Rate (monsters will drop 3 option items)',
	'+5% Drop Rate',
	'+20% Chaos Machine Success Rate',
	'/vipnopk command (enables/disables NON-PVP mode)',
	'+15% Set Item Drop Rate (Land Of Trials)',
);

// DONATE FOR CREDITS SETTINGS
$config['donation_enable'] = true;

// PAYPAL DONATION SETTINGS
$config['paypal_enable'] = false;
$config['paypal_enable_sandbox'] = false;
$config['paypal_email'] = 'paypal@gmail.com';
$config['paypal_title'] = 'Donation for MU coins';
$config['paypal_currency'] = 'USD';
$config['paypal_return_url'] = 'http://www.muonline.com/';
$config['paypal_notify_url'] = 'http://www.muonline.com/api/paypal.php';
$config['paypal_conversion_rate'] = 100; // how many credits is 1 x *currency*

// SUPER REWARDS DONATION SETTINGS
$config['sr_enable'] = false;
$config['sr_h'] = '';
$config['sr_secret'] = '';
$config['sr_conversion_rate'] = 100; // how many credits is 1 x *currency*

// WESTERN UNION DONATION SETTINGS
$config['wu_enable'] = true;

// RANKINGS
$config['rankings_results'] = 50;
$config['rankings_show_date'] = true;
$config['rankings_show_default'] = 'resets'; // level | resets | killers | guilds | grandresets | online
$config['rankings_enable_level'] = true;
$config['rankings_enable_resets'] = true;
$config['rankings_enable_pk'] = true;
$config['rankings_enable_gr'] = false;
$config['rankings_enable_online'] = true;
$config['rankings_enable_votes'] = false; // [NOT ACTIVE]
$config['rankings_enable_guilds'] = true;
$config['rankings_enable_gens'] = false; // [NOT ACTIVE]
$config['rankings_enable_bc'] = true; // [NOT ACTIVE]

// CHANGE PASSWORD SETTINGS
$config['change_password_enable'] = true;
$config['change_password_email_verification'] = true;
$config['change_password_request_timeout'] = 12; // hour(s)

// MASTER KEY RECOVERY SETTINGS
$config['masterkey_recovery_enable'] = true;

// ADD STATS SETTINGS
$config['addstats_enable'] = true;
$config['addstats_enable_zen_requirement'] = true;
$config['addstats_price_zen'] = 100000000;
$config['addstats_max_stats'] = 32767;
$config['addstats_minimum_add_points'] = 10;
$config['url'] = getcwd();

?>
