<?php

/**
 * check_value
 * Looks for valid value and setted ones.
 */
function check_value($value) {
	if((@count($value)>0 and !@empty($value) and @isset($value)) || $value=='0') {
		return true;
	}
}
function makeCharacterLink($name){
    return "<a href='/character/".$name."'>".$name."</a>";
}
function getClassImage($id) {
    global $custom;
    return $custom['character_class'][$id][2];
    
}
function getClassName($id) {
    global $custom;
    return $custom['character_class'][$id][0];
    
}
/**
 * config
 * Returns or prints the value of a config.
 */
function config($config_name, $return = false) {
	global $config;
	if($return) {
		return $config[$config_name];
	} else {
		echo $config[$config_name];
	}
}

/**
 * redirect
 * Performs a redirection.
 */
function redirect($type = 1, $location = null, $delay = 0) {
	if(!check_value($location)) {
		$to = __BASE_URL__;
	} else {
		$to = __BASE_URL__ . $location;
	}

	switch($type) {
		default:
			header('Location: '.$to.'');
			die();
		break;
		case 1:
			header('Location: '.$to.'');
			die();
		break;
		case 2:
			echo '<meta http-equiv="REFRESH" content="'.$delay.';url='.$to.'">';
		break;
		case 3:
			header('Location: '.$location.'');
			die();
		break;
	}
}

/**
 * isLoggedIn
 * Shortcut to the logged in check.
 */
function isLoggedIn() {
	$login = new login();
	if($login->isLoggedIN()) {
		return true;
	} else {
		return false;
	}
}

/**
 * logOutUser
 * Shortcut to the logout process.
 */
function logOutUser() {
	$login = new login();
	$login->logout();
}

/**
 * message
 * Displays and error/success/warning/neutral message.
 */
function message($type = 'neutral',$message = null, $newTitle = null) {
	switch($type) {
		default:
			$class = ' alert-info';
		break;
		case 'error':
			$class = ' alert-danger';
			$title = 'ERROR:';
		break;
		case 'success':
			$class = ' alert-success';
			$title = 'SUCCESS!';
		break;
		case 'warning':
			$class = ' alert-warning';
			$title = 'WARNING:';
		break;
		case 'neutral':
			$class = ' alert-info';
		break;
	}
	
	if(check_value($newTitle)) { $title = $newTitle; }
	
	echo '<div class="alert '.$class.'">';
	if(check_value($title)) { echo '<strong>'.$title.'</strong>   '; }
	echo $message;
	echo '</div>';
}

/**
 * lang
 * Returns or prints the value of a language phrase.
 */
function lang($lang_name, $return = false) {
    global $lang;
    
    if($lang_name == "website_title") {
        $url = array_values(array_filter(explode("/",trim($_SERVER['REQUEST_URI']))));

        switch ($url[0]) {
        case "downloads":
            $lang[$lang_name] = "BloodMu: Pobierz";
        break;
        case "register":
            $lang[$lang_name] = "BloodMu: Zarejestruj się w grze";
            break;
        case "rankings":
            $lang[$lang_name] = "BloodMu: Rankingi - ".$url[1];
            break;
        case "maps":
            $lang[$lang_name] = "BloodMu: Lista map w grze";
            break;
        case "login":
            $lang[$lang_name] = "BloodMu: Zaloguj się do gry ";
            break;
            
            
        case "character":
            $lang[$lang_name] = "BloodMu: ".$url[1];
            break;
        case "halloffame":
            $lang[
            $lang_name] = "BloodMu: Sala sławy";
            break;
        }
    }
    

	if($return) {
		return $lang[$lang_name];
	} else {
		echo $lang[$lang_name];
	}
}

/**
 * Encode
 * 
 */
function Encode($txt) {
	$encryption = new Encryption();
	return $encryption->encode($txt);
}

/**
 * Decode
 * 
 */
function Decode($txt) {
	$encryption = new Encryption();
	return $encryption->decode($txt);
}

/**
 * Debug
 * 
 */
function debug($value) {
	echo '<pre>';
	print_r($value);
	echo '</pre>';
}

/**
 * Randomize Module Titles Background
 * 
 */
function randMTBackground() {
	global $custom;
	$count = count($custom['module_titles_backgrounds']);
	$rand = rand(0,$count-1);
	//$result = '<img src="'.__PATH_TEMPLATE_IMG__.'module-titles/'.$custom['module_titles_backgrounds'][$rand].'" usemap="#moduleback"/>';
	//$result .= '<map name="moduleback"><area shape="rect" coords="13,28,57,72" href="'.__BASE_URL__.'usercp/"></map>';
	return $result;
}

/**
 * Checks if a user has access to the admin panel
 * 
 */
function canAccessAdminCP($username) {
	if(check_value($username)) {
		$search = in_array($username, config('admincp_users_access',true));
		if($search) {
			return true;
		} else {
			return false;
		}
	} else {
		return false;
	}
}

/**
 * Handles admin panel module calling
 * 
 */
function loadAdminCPModule($module='home') {
	global $dB,$dB2,$config,$custom,$_SESSION,$_POST,$_REQUEST,$_GET,$common;
	if(!check_value($module)) { $module = 'home'; }
	if(@file_exists(__PATH_ADMINCP_MODULES__.$module.'.php')) {
		include(__PATH_ADMINCP_MODULES__.$module.'.php');
	} else {
		die('MODULE DOES NOT EXIST');
	}
}

/**
 * Converts any integer into an alphanumeric representation (like a youtube id)
 * requires php_bcmath
 */
function webengine_id($var, $action='encode') {
	$base_chars = "abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"; // DON'T REPEAT A SINGLE CHAR!
	
	for ($n = 0; $n<strlen($base_chars); $n++) {
		$i[] = substr( $base_chars,$n ,1);
    }
 
    $passhash = hash('sha256',config('encryption_hash',true));
    $passhash = (strlen($passhash) < strlen($base_chars)) ? hash('sha512',config('encryption_hash',true)) : $passhash;
 
    for ($n=0; $n < strlen($base_chars); $n++) {
		$p[] =  substr($passhash, $n ,1);
    }
 
    array_multisort($p, SORT_DESC, $i);
    $base_chars = implode($i);
	
	switch($action) {
		case 'encode':
			$string = '';
			$len = strlen($base_chars);
			while($var >= $len) {
				$mod = bcmod($var, $len);
				$var = bcdiv($var, $len);
				$string = $base_chars[$mod].$string;
			}
			return $base_chars[$var] . $string;
		break;
		case 'decode':
			$integer = 0;
			$var = strrev($var );
			$baselen = strlen( $base_chars );
			$inputlen = strlen( $var );
			for ($i = 0; $i < $inputlen; $i++) {
				$index = strpos($base_chars, $var[$i] );
				$integer = bcadd($integer, bcmul($index, bcpow($baselen, $i)));
			}
			return $integer;
		break;
	}
}

/**
 * Encodes an ID to a short string
 * uses function webengine_id()
 */
function Encode_id($id) {
	return webengine_id($id,'encode');
}

/**
 * Decodes a short string into an ID
 * uses function webengine_id()
 */
function Decode_id($id) {
	return webengine_id($id,'decode');
}

/**
 * 
 * 
 */
function BuildCacheData($data_array) {
	$result = null;
	if(is_array($data_array)) {
		foreach($data_array as $row) {
			$count = count($row);
			$i = 1;
			foreach($row as $data) {
				$result .= $data;
				if($i < $count) {
					$result .= '¦';
				}
				$i++;
			}
			$result .= "\n";
		}
		return $result;
	} else {
		return null;
	}
}

/**
 * 
 * 
 */
function UpdateCache($file_name,$data) {
	$file = __PATH_CACHE__.$file_name;
		$fp = fopen($file, 'w+');
		fwrite($fp, time()."\n");
		fwrite($fp, $data);
		fclose($fp);
		return true;

}

/**
 * 
 * 
 */
function LoadCacheData($file_name) {
	$file = __PATH_CACHE__.$file_name;
	if(file_exists($file) && is_readable($file)) {
		$cache_file = file_get_contents($file);
		$file_lanes = explode("\n",$cache_file);
		$nlines = count($file_lanes);
		for($i=0; $i<$nlines; $i++) {
			if(check_value($file_lanes[$i])) {
				$line_data[$i] = explode("¦",$file_lanes[$i]);
			}
		}
		return $line_data;
	} else {
		return null;
	}
}

function sec_to_hms($input_seconds) {
	if($input_seconds >= 1) {
		$hours_module = $input_seconds % 3600;
		$hours = ($input_seconds-$hours_module)/3600;
		$minutes_module = $hours_module % 60;
		$minutes = ($hours_module-$minutes_module)/60;
		$seconds = $minutes_module;
		return array($hours,$minutes,$seconds);
	} else {
		return null;
	}
}?>