<?php
/* --------------------------------------------------------------------

  WebEngine
  http://lautaroangelico.com/webengine/

  @version	1.0.3 PL1
  @author	Lautaro Ang�lico <http://lautaroangelico.com/>
			<angelico.lautaro@gmail.com>

  Copyright (C) 2012-2013
  Lautaro Ang�lico All rights reserved.

  --------------------------------------------------------------------- */

//if(!defined('access') or !access) die('This file cannot be directly accessed.');

session_start();
ob_start();

/* Define execution starts */
define('__WEBENGINE_TIME_EXECUTION_STARTS__', microtime(true));

/* Define current version */
define('__WEBENGINE_VERSION__', '1.0.3 PL1');
define('__WEBENGINE_ACP_VERSION__', '1.0.1');

/* Include the config file */
if(!@include_once(dirname(__FILE__).'/config.php')) die('[WEBENGINE::ERROR][!#] Could not load config.php');
//echo (dirname(__FILE__).'/config.php');

/* Check if System is Active */
if(!$config['system_active']) {
	if(!in_array($_SESSION['username'],$config['admincp_users_access'])) {
		header('Location: '.$config['maintenance_page'].'');
		die();
	}
	$config['enable_session_timeout'] = false;
}

/* Define database connection constants */
define('__SQL_DB_HOST__',	$config['SQL_DB_HOST']);
define('__SQL_DB_NAME__',	$config['SQL_DB_NAME']);
define('__SQL_DB_2_NAME__',	$config['SQL_DB_2_NAME']);
define('__SQL_DB_USER__',	$config['SQL_DB_USER']);
define('__SQL_DB_PASS__',	$config['SQL_DB_PASS']);
define('__SQL_DB_PORT__',	$config['SQL_DB_PORT']);

/* Define database tables */
define('_TBL_FLA_', 'dbo.WEBENGINE_FLA');
define('_TBL_VOTES_', 'dbo.WEBENGINE_VOTES');
define('_TBL_VOTE_LOGS_', 'dbo.WEBENGINE_VOTE_LOGS');
define('_TBL_NEWS_', 'dbo.WEBENGINE_NEWS');
define('_TBL_PAYPAL_', 'dbo.WEBENGINE_PAYPAL_TRANSACTIONS');
define('_TBL_SUPERREWARDS_', 'dbo.WEBENGINE_SR_TRANSACTIONS');
define('_TBL_SUPERREWARDS_ERRORS_', 'dbo.WEBENGINE_SR_ERROR_LOGS');
define('_TBL_CHANGEPASSWORD_REQUEST_', 'dbo.WEBENGINE_PASSCHANGE_REQUEST');
define('_TBL_MI_', 'dbo.MEMB_INFO');
	define('_CLMN_USERNM_', 'memb___id');
	define('_CLMN_PASSWD_', 'memb__pwd');
	define('_CLMN_MEMBID_', 'memb_guid');
	define('_CLMN_EMAIL_', 'mail_addr');
	define('_CLMN_CREDITS_', 'cspoints');
	define('_CLMN_CREDITS_TEMP_', 'TempCredits');
	define('_CLMN_BLOCCODE_', 'bloc_code');
	define('_CLMN_VIP_STAMP_', 'VipStamp');
	define('_CLMN_MASTER_KEY_', 'MasterKey');
define('_TBL_MS_', 'dbo.MEMB_STAT');
	define('_CLMN_CONNSTAT_', 'ConnectStat');
	define('_CLMN_MS_MEMBID_', 'memb___id');
	define('_CLMN_MS_GS_', 'ServerName');
define('_TBL_AC_', 'dbo.AccountCharacter');
	define('_CLMN_AC_ID_', 'Id');
	define('_CLMN_GAMEID_1_', 'GameID1');
	define('_CLMN_GAMEID_2_', 'GameID2');
	define('_CLMN_GAMEID_3_', 'GameID3');
	define('_CLMN_GAMEID_4_', 'GameID4');
	define('_CLMN_GAMEID_5_', 'GameID5');
	define('_CLMN_GAMEIDC_', 'GameIDC');
	define('_CLMN_JOG_', 'JOG');
define('_TBL_CHR_', 'dbo.Character');
	define('_CLMN_CHR_NAME_', 'Name');
	define('_CLMN_CHR_ACCID_', 'AccountID');
	define('_CLMN_CHR_CLASS_', 'Class');
	define('_CLMN_CHR_ZEN_', 'Money');
	define('_CLMN_CHR_LVL_', 'cLevel');
	define('_CLMN_CHR_RSTS_', 'Resets');
	define('_CLMN_CHR_INV_', 'Inventory');
	define('_CLMN_CHR_LVLUP_POINT_', 'LevelUpPoint');
	define('_CLMN_CHR_STAT_STR_', 'Strength');
	define('_CLMN_CHR_STAT_AGI_', 'Dexterity');
	define('_CLMN_CHR_STAT_VIT_', 'Vitality');
	define('_CLMN_CHR_STAT_ENE_', 'Energy');
	define('_CLMN_CHR_STAT_CMD_', 'Leadership');
	define('_CLMN_CHR_PK_KILLS_', 'PkCount');
	define('_CLMN_CHR_PK_LEVEL_', 'PkLevel');
	define('_CLMN_CHR_PK_TIME_', 'PkTime');
	define('_CLMN_CHR_MAP_', 'MapNumber');
	define('_CLMN_CHR_MAP_X_', 'MapPosX');
	define('_CLMN_CHR_MAP_Y_', 'MapPosY');
	define('_CLMN_CHR_MAGIC_L_', 'MagicList');
define('_TBL_LOGEX_', 'dbo.MuLogEx');
define('_TBL_MASTERLVL_', 'dbo.MasterSkillTree');
	define('_CLMN_ML_NAME_', 'Name');
	define('_CLMN_ML_LVL_', 'MasterLevel');
	define('_CLMN_ML_EXP_', 'MasterExperience');
	define('_CLMN_ML_NEXP_', 'MasterSkill');
	define('_CLMN_ML_POINT_', 'MasterPoint');
define('_TBL_MC_', 'dbo.MEMB_CREDITS');
	define('_CLMN_MC_ID_', 'memb___id');
	define('_CLMN_MC_CREDITS_', 'Credits');
	define('_CLMN_MC_TEMPCREDITS_', 'TempCredits');
define('_TBL_REWARD_ITEM_', 'dbo.RewardItem');

/* error reporting */
if($config['error_reporting']==false) {
	ini_set('display_errors', false);
	error_reporting(0);
} else {
	ini_set('display_errors', true);
	error_reporting(E_ALL & ~E_NOTICE);
}

/* encoding */
@ini_set('default_charset', 'utf-8');

/* CloudFlare IP workaround */
//$_SERVER['REMOTE_ADDR'] = (isset($_SERVER["HTTP_CF_CONNECTING_IP"])) ? $_SERVER["HTTP_CF_CONNECTING_IP"] : $_SERVER["REMOTE_ADDR"];

/* URL PATHS */
define('HTTP_HOST', $_SERVER['HTTP_HOST']);
define('SERVER_PROTOCOL', (!empty($_SERVER['HTTPS']) && strtolower($_SERVER['HTTPS']) == 'on' ) ? 'https://' : 'http://');
define('__ROOT_DIR__', str_replace('\\','/',dirname(dirname(__FILE__))).'/'); // /home/user/public_html/
define('__RELATIVE_ROOT__', str_ireplace(rtrim(str_replace('\\','/', realpath(str_replace($_SERVER['SCRIPT_NAME'], '', $_SERVER['SCRIPT_FILENAME']))), '/'), '', __ROOT_DIR__));// /
define('__BASE_URL__', SERVER_PROTOCOL.HTTP_HOST.__RELATIVE_ROOT__); // http(s)://www.mysite.com/

/* SYSTEM PATHS */
define('__PATH_INCLUDES__', __ROOT_DIR__.'includes/');
define('__PATH_TEMPLATES__', __ROOT_DIR__.'templates/');
define('__PATH_TEMPLATES_EXTRA__', __ROOT_DIR__.'templates/'.$config['website_template'].'/extra/');
define('__PATH_TEMPLATE__', __BASE_URL__ . 'templates/' . $config['website_template'] . '/');
define('__PATH_TEMPLATE_IMG__', __BASE_URL__ . 'templates/' . $config['website_template'] . '/img/');
define('__PATH_LANGUAGES__', __ROOT_DIR__ . 'languages/');
define('__PATH_MAINTENANCE__', __ROOT_DIR__.'maintenance/');
define('__PATH_CLASSES__', __PATH_INCLUDES__.'classes/');
define('__PATH_FUNCTIONS__', __PATH_INCLUDES__.'functions/');
define('__PATH_MODULES__', __ROOT_DIR__.'modules/');
define('__PATH_MODULES_USERCP__', __PATH_MODULES__.'usercp/');
define('__PATH_MODULES_RANKINGS__', __BASE_URL__.'rankings/');
define('__PATH_EMAILS__', __PATH_INCLUDES__.'emails/');
define('__PATH_CACHE__', __PATH_INCLUDES__.'cache/');
define('__PATH_ADMINCP__', __ROOT_DIR__.'admincp/');
define('__PATH_ADMINCP_MODULES__', __ROOT_DIR__.'admincp/modules/');
define('__PATH_ADMINCP_HOME__', __BASE_URL__.'admincp/');
define('__PATH_NEWS_CACHE__', __PATH_CACHE__.'news/');

//new
define('__PATH_TEMPLATE_CSS__',__PATH_TEMPLATE__.'/css/');
define('__PATH_TEMPLATE_JS__', __PATH_TEMPLATE__.'/js/');
define('__PATH_TEMPLATE_ROOT__', __PATH_TEMPLATES__.$config['website_template'].'/');

/* MuEngine Bridge */
define("PROTO_GLOBAL_MESSAGE","A1");
define("PROTO_DISCONNECT","A3");
define("PROTO_BAN_DISCONNECT","A4");
define("PROTO_EMAIL_SEND","A5");
define("PROTO_BLSN_RELOAD","A6");

/* DEFINE CLASSES */
$webengine_classes = array(
	'class.database.php',
	'class.database2.php',
	'class.common.php',
	'class.handler.php',
	'class.validator.php',
	'class.login.php',
	'class.vote.php',
	'class.character.php',
	'class.encryption.php',
	'class.phpmailer.php',
	'class.smtp.php',
	'class.vip.php',
	'class.rankings.php',
    'class.reset.php',
	'class.news.php',
	'class.items.php',
	'class.muengine.php',
    'class.shop.php',
    'class.shoutbox.php'
);

/* DEFINE FUNCTIONS */
$webengine_functions = array(
	'function.global.php',
	'function.email.php',
	'function.recaptchalib.php'
);

/* LOAD CLASSES AND FUNCTIONS */
foreach($webengine_classes as $loadClass) {
	if(!@include_once(__PATH_CLASSES__.$loadClass)) die('[WEBENGINE::ERROR][!#] Could not load '.$loadClass.'');
}
foreach($webengine_functions as $loadFunction) {
	if(!@include_once(__PATH_FUNCTIONS__.$loadFunction)) die('[WEBENGINE::ERROR][!#] Could not load '.$loadFunction.'');
}

// LOAD DATABASE CONNECTION ::
$dB = new dB();
$common = new common();

// LOAD SECOND DATABASE CONNECTION ::

if($config['SQL_USE_2_DB']) {
$dB2 = new dB2();
}
// LOAD CUSTOM DATA
if(!@include_once(__PATH_INCLUDES__.'custom.php')) die('[WEBENGINE::ERROR][!#] Could not load custom.php');


// LOAD PAGE ::
if($stopRender != true) {
    $handler = new Handler();
    $handler->loadPage();
}
?>