/* 
 * JavaScript classes for dmnmucms
 * Author: neo6 <Salvis87@inbox.lv>
 *
 */

var App = {
	user_info: [],
	nameRegex: /^[0-9a-zA-Z_-]+$/,
	lc: null,
	item_slot: -1,
	first: true,
	page: false,
	clicks: 0,
	login: 0,
	isfirst: false,
	events_time: [],
	isSending: false,
	initialize: function () {
		if (DmNConfig.ajax_page_load == 1) {
			App.historyPush();
		}
		serverTime.init("ServerTime", "LocalTime");
	},
	initLocalization: function(){
	},
	castleSiegeCountDown: function (id, end, start) {
		this.container = $('#' + id);
		this.endDate = new Date(end * 1000);
		this.startDate = new Date(start * 1000);
		if(new Date().getTime() > this.endDate){
			this.container.html(App.lc.translate('Battle Ended').fetch());
		}
		else{
			var context = this,
				update = function () {
					context.startDate.setSeconds(context.startDate.getSeconds() + 1);
					var timediff = (context.endDate - context.startDate) / 1000;
					if (timediff < 0) {
						context.container.html(App.lc.translate('Battle Now').fetch());
					}
					else {
						context.container.html(App.formatedTime(timediff));
						setTimeout(update, 1000);
					}
				};
			update();
		}
	},
	showTime: function (div) {
		var currentTime = new Date();
		var hours = currentTime.getHours();
		var minutes = currentTime.getMinutes();
		var seconds = currentTime.getSeconds();
		if (minutes < 10) {
			minutes = '0' + minutes;
		}
		if (seconds < 10) {
			seconds = '0' + seconds;
		}
		var v = hours + ':' + minutes + ':' + seconds;
		setTimeout(function () {
			App.showTime(div);
		}, 1000);
		$('#' + div).html(v);
	},
	tooltipImageShow: function (source) {
		var img = new Image();
		img.onload = function () {
			if (this.height > $(window).height()) {
				$(".tooltip-div-image").css("padding-top", 20 + "px");
				$(".tooltip-image").css("height", $(window).height() - 40 + "px");
			}
			else {
				$(".tooltip-div-image").css("padding-top", ($(window).height() - this.height) / 2 + "px");
				$(".tooltip-image").css("height", this.height + "px")
			}

			$(".tooltip-image").attr("src", this.src);
			$(".tooltip-div").css("height", $(document).height() + "px").fadeIn(400);
		}
		img.src = source;
	},
	getEventTimes: function () {
		App.events_time = DmNConfig.timers;
		if (App.isfirst == false) {
			App.events();
			App.isfirst = true;
		}
	},
	getEventTimesLive: function () {
		$.ajax({
			url: DmNConfig.base_url + "ajax/event-timers",
			success: function (data) {
				App.events_time = data;
				if (App.isfirst == false) {
					App.events();
					App.isfirst = true;
				}
			}
		});
	},
	events: function () {
		i = 0;
		for (i in App.events_time) {
			newDiv = $("<div/>");
			newDiv.append($("<span />").text(App.events_time[i].name));
			newDiv.append($("<small />").attr({id: 'event' + App.events_time[i].id}).text(App.formatedTime(App.events_time[i].left)));
			$("#events").append(newDiv);
			i++;
		}
		setInterval(function () {
			App.updateEventTimes()
		}, 1000);
	},
	updateEventTimes: function () {
		for (i in App.events_time) {
			App.events_time[i].left--;
			if (App.events_time[i].left < 0) {
				App.events_time[i].left++;
				App.getEventTimesLive();
			}
			$("#event" + App.events_time[i].id).text(App.formatedTime(App.events_time[i].left));
		}
	},
	sprintf: function (format) {
		for (var i = 1; i < arguments.length; i++) {
			format = format.replace(/%s|%d/, arguments[i]);
		}
		return format;
	},
	count_down: function (target) {
		var serverDate = App.serverDate();
		var targetDate = new Date(target);
		setInterval(function () {
			serverDate.setSeconds(serverDate.getSeconds() + 1);
			App.updateTime(serverDate, targetDate)
		}, 1000);
	},
	checkTime: function (i) {
		if (i < 10) {
			i = "0" + i;
		}
		return i;
	},
	timeDifference: function (begin, end) {
		if (end < begin) {
			return false;
		}
		var diff = {
			seconds: [end.getSeconds() - begin.getSeconds(), 60],
			minutes: [end.getMinutes() - begin.getMinutes(), 60],
			hours: [end.getHours() - begin.getHours(), 24],
			days: [end.getDate() - begin.getDate(), new Date(begin.getYear(), begin.getMonth() + 1, 0).getDate()],
		};
		var result = new Array();
		var flag = false;
		for (i in diff) {
			if (flag) {
				diff[i][0]--;
				flag = false;
			}
			if (diff[i][0] < 0) {
				flag = true;
				diff[i][0] += diff[i][1];
			}
			if (i == 'days' && !diff[i][0]) continue;
			result.push(App.checkTime(diff[i][0]));
		}
		return result.reverse().join(':');
	},
	updateTime: function (serverDate, targetDate) {
		var s = App.timeDifference(serverDate, targetDate);
		if (s.length) {
			var days, hours, minutes, seconds;
			var seconds_left = (targetDate.getTime() - serverDate.getTime()) / 1000;
			days = parseInt(seconds_left / 86400);
			seconds_left = seconds_left % 86400;
			hours = parseInt(seconds_left / 3600);
			seconds_left = seconds_left % 3600;
			minutes = parseInt(seconds_left / 60);
			seconds = parseInt(seconds_left % 60);
			$('#days').html(days);
			$('#hours').html(hours);
			$('#minutes').html(minutes);
			$('#seconds').html(seconds);
		}
		else {
			$('#timer_div_title').hide();
			$('#timer_div_time').hide();
			clearInterval(App.updateTime(serverDate, targetDate));
		}
	},
	serverDate: function () {
		time = new Date(DmNConfig.currenttime);
		return time;
	},
	formatedTime: function (seconds) {
		second = seconds % 60;
		minutes = parseInt((seconds / 60) % 60);
		hour = parseInt((seconds / 3600) % 24);
		days = parseInt(seconds / (24 * 3600));
		html = '';
		if (days > 0)
			html += days + 'd ';
		if (hour > 0)
			html += hour + 'h ';
		if (days > 0 && hour <= 0)
			html += '0h ';
		if (minutes > 0)
			html += minutes + 'm ';
		if (minutes < 0)
			html += '0m ';
		if (second < 10)
			second = '0' + second;
		html += second + 's';
		return html;
	},
	setIsSending: function () {
		setTimeout(function () {
			App.isSending = false;
		}, 500);
	}
};

var serverTime = {
    serverDate: null,
    localDate: null,
    dateOffset: null,
    nowDate: null,
    eleServer: null,
    eleLocal: null,
    init: function(e, c){
        var f = this;
        f.eleServer = e;
        f.eleLocal = c;
        f.serverDate = new Date(DmNConfig.currenttime);
        f.localDate = new Date();
        
        f.dateOffset = f.serverDate - f.localDate;
		$('#'+f.eleServer).html('Server Time: '+f.dateTimeFormat(f.serverDate));
		$('#'+f.eleLocal).html('Local Time: '+f.dateTimeFormat(f.localDate));
        setInterval(function(){
            f.update()
        }, 1000)
        
    },
    update: function(){
        var b = this;
        b.nowDate = new Date();
		$('#'+b.eleLocal).html(b.dateTimeFormat(b.nowDate));
        b.nowDate.setTime(b.nowDate.getTime() + b.dateOffset);
		$('#'+b.eleServer).html(b.dateTimeFormat(b.nowDate));
    },
    dateTimeFormat: function(e){
        var c = this;
        var f = [];
        f.push(c.digit(e.getHours()));
        f.push(":");
        f.push(c.digit(e.getMinutes()));
        f.push(":");
        f.push(c.digit(e.getSeconds()));
        f.push(" ");
        f.push(" ");
        f.push(" ");
        f.push(e.getDate());
        return f.join("")
    },
    digit: function(b){
        b = String(b);
        b = b.length == 1 ? "0" + b : b;
        return b
    },
};

