<?php
/* --------------------------------------------------------------------

  WebEngine
  http://lautaroangelico.com/webengine/

  @version	1.0.3
  @author	Lautaro Anglico <http://lautaroangelico.com/>
			<angelico.lautaro@gmail.com>

  Copyright (C) 2012-2013 Lautaro Anglico All rights reserved.

  --------------------------------------------------------------------- */

$Rankings = new Rankings();

// Rankings to display
$show_rankings = (check_value($_REQUEST['type'])) ? $_REQUEST['type'] : "".config('rankings_show_default',true)."";

$rankings_menu = array(
	array(lang('rankings_txt_1',true),'level',config('rankings_enable_level',true)),
	array(lang('rankings_txt_2',true),'resets',config('rankings_enable_resets',true)),
	array(lang('rankings_txt_3',true),'killers',config('rankings_enable_pk',true)),
	array(lang('rankings_txt_4',true),'guilds',config('rankings_enable_guilds',true)),
	array(lang('rankings_txt_5',true),'grandresets',config('rankings_enable_gr',true)),
	array(lang('rankings_txt_6',true),'online',config('rankings_enable_online',true)),
	array(lang('rankings_txt_7',true),'votes',config('rankings_enable_votes',true)),
	array(lang('rankings_txt_8',true),'gens',config('rankings_enable_gens',true)),
    array('Blood Castle','BC','BC'),
);

echo '<div class="rankings_menu">';
foreach($rankings_menu as $rm_item) {
	if($rm_item[2]) {
		if($show_rankings == $rm_item[1]) {
			echo '<a href="'.__PATH_MODULES_RANKINGS__.$rm_item[1].'/" class="active">'.$rm_item[0].'</a>';
		} else {
			echo '<a href="'.__PATH_MODULES_RANKINGS__.$rm_item[1].'/">'.$rm_item[0].'</a>';
		}
	}
}
echo '</div>';

switch($show_rankings) {
	case 'level':
		goto rankings_level;
	break;
	case 'resets':
		goto rankings_resets;
	break;
	case 'killers':
		goto rankings_pk;
	break;
	case 'grandresets':
		goto rankings_gr;
	break;
	case 'online':
		goto rankings_online;
	break;
	case 'votes':
		goto rankings_votes;
	break;
	case 'guilds':
		goto rankings_guilds;
	break;
	case 'gens':
		goto rankings_gens;
	break;
	case 'BC':
	    goto BC;
	    break;
	default:
		goto disabled;
	break;
}

// Level Rankings
rankings_level:
	if(config('rankings_enable_level',true)):		
		$ranking_data = LoadCacheData('rankings_level.cache');
		echo '<table class="rankings-table">';
		echo '<tr>';
		echo '<td style="font-weight:bold;">#</td>';
		echo '<td style="font-weight:bold;">'.lang('rankings_txt_10',true).'</td>';
		echo '<td style="font-weight:bold;">'.lang('rankings_txt_11',true).'</td>';
		echo '<td style="font-weight:bold;">'.lang('rankings_txt_12',true).'</td>';
		echo '</tr>';
		$i = 0;
		foreach($ranking_data as $rdata) {
			if($i>=1) {
				echo '<tr>';
				echo '<td>'.$i.'</td>';
				echo '<td>';
				
				if($common->isCharacterOnlineSPEED($rdata[0])) { echo '<span class="online"></span>'; }

                echo makeCharacterLink($rdata[0]).'</td>';
				echo '<td>'.$custom['character_class'][$rdata[1]][0].'</td>';
				echo '<td>'.$rdata[2].'</td>';
				echo '</tr>';
			}
			$i++;
		}
		echo '</table>';
		echo '<div style="text-align: center;font-size: 9px;">';
		echo ''.lang('rankings_txt_20',true).' ' . date("m/d/Y - h:i A",$ranking_data[0][0]);
		echo '</div>';
	else:
		goto disabled;
	endif;
goto end;





// Resets Rankings
rankings_resets:
	if(config('rankings_enable_resets',true)):		
		$ranking_data = LoadCacheData('rankings_resets.cache');
		echo '<table class="rankings-table">';
		echo '<tr>';
		echo '<td style="font-weight:bold;">#</td>';
		echo '<td style="font-weight:bold;">'.lang('rankings_txt_10',true).'</td>';
		echo '<td style="font-weight:bold;">'.lang('rankings_txt_11',true).'</td>';
		echo '<td style="font-weight:bold;">Grand resets</td>';
		echo '<td style="font-weight:bold;">'.lang('rankings_txt_13',true).'</td>';
		echo '</tr>';
		$i = 0;
		foreach($ranking_data as $rdata) {
			if($i>=1) {
				echo '<tr>';
				echo '<td>'.$i.'</td>';
				echo '<td>';
				if($common->isCharacterOnlineSPEED($rdata[0])) { echo '<span class="online"></span>'; }
				echo makeCharacterLink($rdata[0]).'</td>';
				echo '<td>'.$custom['character_class'][$rdata[1]][0].'</td>';
				echo '<td>'.(floor($rdata[2]/100)).'</td>';
				echo '<td>'.($rdata[2]%100).'</td>';
				echo '</tr>';
			}
			$i++;
		}
		echo '</table>';
		echo '<div style="text-align: center;font-size: 9px;">';
		echo ''.lang('rankings_txt_20',true).' ' . date("m/d/Y - h:i A",$ranking_data[0][0]);
		echo '</div>';
	else:
		goto disabled;
	endif;
goto end;





// PK Rankings
rankings_pk:
	if(config('rankings_enable_pk',true)):
		$ranking_data = LoadCacheData('rankings_pk.cache');
		echo '<table class="rankings-table">';
		echo '<tr>';
		echo '<td style="font-weight:bold;">#</td>';
		echo '<td style="font-weight:bold;">'.lang('rankings_txt_10',true).'</td>';
		echo '<td style="font-weight:bold;">'.lang('rankings_txt_11',true).'</td>';
		echo '<td style="font-weight:bold;">'.lang('rankings_txt_14',true).'</td>';
		echo '</tr>';
		$i = 0;
		foreach($ranking_data as $rdata) {
			if($i>=1) {
				echo '<tr>';
				echo '<td>'.$i.'</td>';
				echo '<td>'; 
				if($common->isCharacterOnlineSPEED($rdata[0])) { echo '<span class="online"></span>'; }
				echo makeCharacterLink($rdata[0]).'</td>';
				echo '<td>'.$custom['character_class'][$rdata[1]][0].'</td>';
				echo '<td>'.$rdata[2].'</td>';
				echo '</tr>';
			}
			$i++;
		}
		echo '</table>';
		echo '<div style="text-align: center;font-size: 9px;">';
		echo ''.lang('rankings_txt_20',true).' ' . date("m/d/Y - h:i A",$ranking_data[0][0]);
		echo '</div>';
	else:
		goto disabled;
	endif;
goto end;





// Grand Resets Rankings
rankings_gr:
	if(config('rankings_enable_gr',true)):
		$ranking_data = LoadCacheData('rankings_gr.cache');
		echo '<table class="rankings-table">';
		echo '<tr>';
		echo '<td style="font-weight:bold;">#</td>';
		echo '<td style="font-weight:bold;">'.lang('rankings_txt_10',true).'</td>';
		echo '<td style="font-weight:bold;">'.lang('rankings_txt_11',true).'</td>';
		echo '<td style="font-weight:bold;">'.lang('rankings_txt_21',true).'</td>';
		echo '</tr>';
		$i = 0;
		foreach($ranking_data as $rdata) {
			if($i>=1) {
				echo '<tr>';
				echo '<td>'.$i.'</td>';
				echo '<td>'; 
				if($common->isCharacterOnlineSPEED($rdata[0])) { echo '<span class="online"></span>'; }
				echo makeCharacterLink($rdata[0]).'</td>';
				echo '<td>'.$custom['character_class'][$rdata[1]][0].'</td>';
				echo '<td>'.$rdata[2].'</td>';
				echo '</tr>';
			}
			$i++;
		}
		echo '</table>';
		echo '<div style="text-align: center;font-size: 9px;">';
		echo ''.lang('rankings_txt_20',true).' ' . date("m/d/Y - h:i A",$ranking_data[0][0]);
		echo '</div>';
	else:
		goto disabled;
	endif;
goto end;





// Online Rankings
rankings_online:
	if(config('rankings_enable_online',true)):
		$ranking_data = LoadCacheData('rankings_online.cache');
		echo '<table class="rankings-table">';
		echo '<tr>';
		echo '<td style="font-weight:bold;">#</td>';
		echo '<td style="font-weight:bold;">'.lang('rankings_txt_10',true).'</td>';
		echo '<td style="font-weight:bold;">'.lang('rankings_txt_15',true).'</td>';
		echo '</tr>';
		$i = 0;
		foreach($ranking_data as $rdata) {
			if($i>=1) {
				echo '<tr>';
				echo '<td>'.$i.'</td>';
				echo '<td>';
				if($common->isCharacterOnlineSPEED($rdata[0])) { echo '<span class="online"></span>'; }
				echo makeCharacterLink($rdata[0]).'</td>';
				echo '<td>'.round($rdata[1]).' '.lang('rankings_txt_16',true).'</td>';
				echo '</tr>';
			}
			$i++;
		}
		echo '</table>';
		echo '<div style="text-align: center;font-size: 9px;">';
		echo ''.lang('rankings_txt_20',true).' ' . date("m/d/Y - h:i A",$ranking_data[0][0]);
		echo '</div>';
	else:
		goto disabled;
	endif;
goto end;





// Vote Rankings
rankings_votes:
	if(config('rankings_enable_votes',true)):
		echo 'votes rankings';
	else:
		goto disabled;
	endif;
goto end;





// Guilds Rankings
rankings_guilds:
	if(config('rankings_enable_guilds',true)):
		$ranking_data = LoadCacheData('rankings_guilds.cache');
		echo '<table class="rankings-table">';
		echo '<tr>';
		echo '<td style="font-weight:bold;">#</td>';
		echo '<td style="font-weight:bold;">'.lang('rankings_txt_17',true).'</td>';
		echo '<td style="font-weight:bold;">'.lang('rankings_txt_18',true).'</td>';
		echo '<td style="font-weight:bold;">'.lang('rankings_txt_19',true).'</td>';
		echo '</tr>';
		$i = 0;
		foreach($ranking_data as $rdata) {
			if($i>=1 && $rdata[2] >= 0) {
				echo '<tr>';
				echo '<td>'.$i.'</td>';
				echo '<td>'.$rdata[0].'</td>';
				echo '<td>'.(makeCharacterLink($rdata[1])).'</td>';
				echo '<td>'.$rdata[2].'</td>';
				echo '</tr>';
			}
			$i++;
		}
		echo '</table>';
		echo '<div style="text-align: center;font-size: 9px;">';
		echo ''.lang('rankings_txt_20',true).' ' . date("m/d/Y - h:i A",$ranking_data[0][0]);
		echo '</div>';
	else:
		goto disabled;
	endif;
goto end;

// Gens Rankings
rankings_gens:
	if(config('rankings_enable_gens',true)):
		echo 'gens rankings';
	else:
		goto disabled;
	endif;
goto end;

// Gens Rankings
BC:
    if(config('rankings_enable_bc',true)):
        $ranking_data = LoadCacheData('rankings_bc.cache');
            echo '<table class="rankings-table">';
            echo '<tr>';
            echo '<td style="font-weight:bold;">#</td>';
            echo '<td style="font-weight:bold;">Account</td>';
            echo '<td style="font-weight:bold;">Score</td>';
            echo '</tr>';
            $i = 0;
            foreach($ranking_data as $rdata) {
                if($i>=1 && $rdata[1] >= 0) {
                    echo '<tr>';
                    echo '<td>'.$i.'</td>';
                    echo '<td>'.(makeCharacterLink($rdata[0])).'</td>';
                    echo '<td>'.$rdata[1].'</td>';
                    echo '</tr>';
                }
                $i++;
            }
            echo '</table>';
            echo '<div style="text-align: center;font-size: 9px;">';
            echo ''.lang('rankings_txt_20',true).' ' . date("m/d/Y - h:i A",$ranking_data[0][0]);
            echo '</div>';
    else:
        goto disabled;
    endif;
goto end;

disabled:
message('error', lang('error_44',true));

end:
?>