<?php
/* --------------------------------------------------------------------

  WebEngine
  http://lautaroangelico.com/webengine/

  @version	1.0.3
  @author	Lautaro Angélico <http://lautaroangelico.com/>
			<angelico.lautaro@gmail.com>

  Copyright (C) 2012-2013 Lautaro Angélico All rights reserved.

  --------------------------------------------------------------------- */

if(isLoggedIn()) { redirect(); }

echo '
<div class="page-container">
	<div class="page-title"><span>'.lang('module_titles_txt_1',true).'</span></div>
	<div class="page-content">';
	
		if(config('register_enable',true)) {
			// Register Process
			if(check_value($_POST['submit'])) {
				if(config('register_enable_recaptcha',true)) {
					$resp = recaptcha_check_answer(config('register_recaptcha_private_key',true),$_SERVER["REMOTE_ADDR"],$_POST["recaptcha_challenge_field"],$_POST["recaptcha_response_field"]);
					if(!$resp->is_valid) {
						message('error',lang('error_18',true));
					} else {
						$common->registerAccount($_POST['username'],$_POST['password'],$_POST['password_confirm'],$_POST['email']);
					}
				} else {
					$common->registerAccount($_POST['username'],$_POST['password'],$_POST['password_confirm'],$_POST['email']);
				}
			}
		
			echo '
			<form action="" method="post" >
	        <div class="form-group">
                <label class="control-label" for="inputUser">'.lang('register_txt_1',true).'</label>
                <div class="controls">
                    <input type="text" class="form-control" name="username" id="inputUser" />
                    <span>'.lang('register_txt_6',true).'</span>
                </div>
            </div>
	        <div class="form-group">
                <label class="control-label" for="inputPasswd">'.lang('register_txt_2',true).'</label>
                <div class="controls">
                    <input type="password" name="password" id="inputPasswd" class="form-control" />
                    <span>'.lang('register_txt_7',true).'</span>
                </div>
            </div>
	        <div class="form-group">
                <label class="control-label" for="confirmPasswd">'.lang('register_txt_3',true).'</label>
                <div class="controls">
                    <input type="password" name="password_confirm" id="confirmPasswd" class="form-control"  />
                    <span>'.lang('register_txt_8',true).'</span>
                </div>
            </div>
	        <div class="form-group">
                <label class="control-label" for="email">'.lang('register_txt_4',true).'</label>
                <div class="controls">
                    <input type="text" name="email"  id="email" class="form-control" />
                    <span>'.lang('register_txt_9',true).'</span>
                </div>
            </div>
	        <div class="form-group">
                <label class="control-label"></label>
                <span>'.lang('register_txt_10',true).'</span>
            </div>
            <div class="form-group">
                <div class="controls">
                    <input class="btn" type="submit" name="submit" value="'.lang('register_txt_5',true).'"/>
                </div>
            </div>
<!--
<table>
					<tr>
						<td>'.lang('register_txt_1',true).'</td>
						<td>
                            <input type="text" name="username" /><br /><span>'.lang('register_txt_6',true).'</span>
                        </td>
					</tr>
					<tr>
						<td>'.lang('register_txt_2',true).'</td>
						<td>
                        <input type="password" name="password" /><br /><span>'.lang('register_txt_7',true).'</span>
                        </td>
					</tr>
					<tr>
						<td>'.lang('register_txt_3',true).'</td>
						<td>
                        <input type="password" name="password_confirm" /><br />
                        <span>'.lang('register_txt_8',true).'</span>
                        </td>
					</tr>
					<tr>
						<td>'.lang('register_txt_4',true).'</td>
						<td><input type="text" name="email" /><br /><span>'.lang('register_txt_9',true).'</span></td>
					</tr>';
					
					if(config('register_enable_recaptcha',true)) {
					echo '
					<tr>
						<td colspan="2"><div style="padding-left: 30px;">'. recaptcha_get_html(config('register_recaptcha_public_key',true)) .'</div></td>
					</tr>';
					}
					
					echo '
					<tr>
						<td></td>
						<td>'.lang('register_txt_10',true).'</td>
					</tr>
					<tr>
						<td colspan="2" class="register-table-submit">
                            <input class="neon box small" type="submit" name="submit" value="'.lang('register_txt_5',true).'"/>
                        </td>
					</tr>
				</table> --!>
			</form>';
		} else {
			message('error',lang('error_17',true));
		}
		
	echo '
	</div>
</div>
';