<?php
/* --------------------------------------------------------------------

  WebEngine
  http://lautaroangelico.com/webengine/

  @version	1.0.3
  @author	Lautaro Angélico <http://lautaroangelico.com/>
			<angelico.lautaro@gmail.com>

  Copyright (C) 2012-2013 Lautaro Angélico All rights reserved.

  --------------------------------------------------------------------- */

echo '
<div class="page-container">
	<div class="bg-module-title">
		<span class="title">'.lang('module_titles_txt_25',true).'</span>
		'.randMTBackground().'
	</div>
	<div class="page-content">';
	
		if(config('addstats_enable',true)) {
			$Character = new Character();
			$AccountCharacters = $Character->AccountCharacter($_SESSION['username']);
			
			if(is_array($AccountCharacters)) {
			
				// Reset Process
				if(check_value($_POST['submit'])) {
					$Character->CharacterAddStats($_SESSION['username'],$_POST['character'],$_POST['add_str'],$_POST['add_agi'],$_POST['add_vit'],$_POST['add_ene'],$_POST['add_com']);
				}
				
				if(config('addstats_enable_zen_requirement',true)) {
					message('','<ul>
					<li>'.config('addstats_price_zen',true).' '.lang('zen_requirement_1a',true).'</li>
					</ul>',lang('module_requirements',true));
				}
				
				echo '
					<table class="general-table-ui" cellspacing="0">
						<tr>
							<td></td>
							<td>'.lang('addstats_txt_1',true).'</td>
							<td>'.lang('addstats_txt_2',true).'</td>
							<td>'.lang('addstats_txt_3',true).'</td>
							<td>'.lang('addstats_txt_4',true).'</td>
							<td>'.lang('addstats_txt_5',true).'</td>
							<td>'.lang('addstats_txt_6',true).'</td>
							<td>'.lang('addstats_txt_7',true).'</td>
							<td></td>
						</tr>';

						foreach($AccountCharacters as $thisCharacter)
						{
						
							$characterData = $Character->CharacterData($thisCharacter);
							$characterIMG = $Character->GenerateCharacterClassAvatar($characterData[_CLMN_CHR_CLASS_]);
							
							echo '<form action="" method="post">
							<input type="hidden" name="character" value="'.Encode($characterData[_CLMN_CHR_NAME_]).'"/>
							<tr>
							<td>'.$characterIMG.'</td>
							<td>'.$characterData[_CLMN_CHR_NAME_].'</td>
							<td>'.$characterData[_CLMN_CHR_LVLUP_POINT_].'</td>
							<td><input style="width: 40px;" type="text" name="add_str" maxlength="5"/></td>
							<td><input style="width: 40px;" type="text" name="add_agi" maxlength="5" /></td>
							<td><input style="width: 40px;" type="text" name="add_vit" maxlength="5" /></td>
							<td><input style="width: 40px;" type="text" name="add_ene" maxlength="5" /></td>';
							if($characterData[_CLMN_CHR_CLASS_] == 50 || $characterData[_CLMN_CHR_CLASS_] == 64 || $characterData[_CLMN_CHR_CLASS_] == 66) {
								echo '<td><input style="width: 40px;" type="text" name="add_com" maxlength="5" /></td>';
							} else {
								echo '<td><input style="width: 40px;" type="text" name="add_com" maxlength="5" disabled="disabled" value="0"/></td>';
							}
							echo '<td><input class="neon small box" type="submit" name="submit" value="'.lang('addstats_txt_8',true).'"/></a></td></tr>
							</form>';
						
						}
			echo '</table>';
		} else {
			message('error', lang('error_46',true));
		}
	} else {
		message('error', lang('error_47',true));
	}
	
echo '
	</div>
</div>
';
?>