<?php
/* --------------------------------------------------------------------

  WebEngine
  http://lautaroangelico.com/webengine/

  @version	1.0.3
  @author	Lautaro Angélico <http://lautaroangelico.com/>
			<angelico.lautaro@gmail.com>

  Copyright (C) 2012-2013 Lautaro Angélico All rights reserved.

  --------------------------------------------------------------------- */

// Load Character Class
$Character = new Character();

echo '
<div class="page-container">
	<div class="page-title"><span>
        '.lang('module_titles_txt_13',true).'
    </span></div>
	<div class="page-content">';
		if(config('clearpk_enable',true)) {
			$AccountCharacters = $Character->AccountCharacter($_SESSION['username']);
			
			if(is_array($AccountCharacters)) {
			
				// Clear PK Process
				if(check_value($_POST['submit'])) {
					$Character->CharacterClearPK($_SESSION['username'],$_POST['character']);
				}
				
				if(config('clearpk_enable_zen_requirement',true)) {
					message('','<ul>
					<li>'.config('clearpk_price_zen',true).' '.lang('zen_requirement_1a',true).'</li>
					</ul>',lang('module_requirements',true));
				}
				
				echo '
					<table class="general-table-ui" cellspacing="0">
						<tr>
							<td></td>
							<td>'.lang('clearpk_txt_1',true).'</td>
							<td>'.lang('clearpk_txt_2',true).'</td>
							<td>'.lang('clearpk_txt_3',true).'</td>
							<td></td>
						</tr>';

						foreach($AccountCharacters as $thisCharacter)
						{
						
							$characterData = $Character->CharacterData($thisCharacter);
							$characterIMG = $Character->GenerateCharacterClassAvatar($characterData[_CLMN_CHR_CLASS_]);
							
							echo '<form action="" method="post">
							<input type="hidden" name="character" value="'.Encode($characterData[_CLMN_CHR_NAME_]).'"/>
							<tr>
							<td>'.$characterIMG.'</td>
							<td>'.$characterData[_CLMN_CHR_NAME_].'</td>
							<td>'.$characterData[_CLMN_CHR_ZEN_].'</td>
							<td>'.$characterData[_CLMN_CHR_PK_KILLS_].'</td>
							<td><input class="neon small box" type="submit" name="submit" value="'.lang('clearpk_txt_4',true).'"/></a></td></tr>
							</form>';
						
						}
				echo '</table>';
		
			} else {
				message('error', lang('error_46',true));
			}
		} else {
			message('error', lang('error_47',true));
		}
	
echo '	
	</div>
</div>
';
?>