<?php
/* --------------------------------------------------------------------

  WebEngine
  http://lautaroangelico.com/webengine/

  @version	1.0.3
  @author	Lautaro Ang�lico <http://lautaroangelico.com/>
			<angelico.lautaro@gmail.com>

  Copyright (C) 2012-2013 Lautaro Ang�lico All rights reserved.

  --------------------------------------------------------------------- */
$shoutbox = new ShoutBox();
$lista = $shoutbox->getRecords();
?>
<style>
#blokChat {
    float:left;
    width:100%;
    height:300px;
    border:1px solid #CCC;
    margin-bottom:20px;
    padding:10px;
    overflow:auto;
}
#blokChat .elm1 {
padding-right:4px;
}
#blokChat .elm2 {
}
#blokChat .elm3 {
margin-top:-5px;
display:block;
color:#AAA;
}
</style>
<div class="page-container">
	<div class="page-title">
		<span>
			<?=lang('module_titles_txt_3',true);?>
		</span>
	</div>
	<div class="page-content" id="chat">
		<?php 
    		if(!empty($_SESSION['username'])) {
    		    $cc = new Character();
    		    $users = $cc->AccountCharacter($_SESSION['username']);
    		} else {
    		    $users[0]="Guest";
    		}
		?>
		<h2>Tablica ogłoszeń</h2>
		<div id="blokChat">
    		<?php foreach($lista as $i): ?>
    			<div class="col">
            		<span class="elm1"><b><a href="/character/<?php echo $i["USER"]; ?>"><?php echo $i["USER"]; ?></a>:</b></span>
            		<span class="elm2"><?php echo $i["TEXT"]; ?></span>
            		<span class="elm3">
            			<small>
            				<?php echo gmdate("m-d H:i:s", $i["DATE"]); ?>
            			</small>
            		</span>
    			</div>
    		<?php endforeach;?>
    	</div>
    	<div class="form-inline">
          <div class="form-group">
            <select class="form-control" name="user" style="width:100px;" >
    		<?php 
    		foreach($users as $item) {
    		    echo "<option valie='".$item."'>".$item."</option>";
    		} ?></select>
            <input type="text" name="wiadomosc" class="form-control" maxlength="255" style="width:380px;" id="wiadomosc" placeholder="tekst...">
          </div>
          <button id="zapisz" class="btn btn-default">Napisz</button>
          <button id="refresh" class="btn btn-default">Refresh</button>
        </div>
	</div>
</div>

<script>
$(function() {
	$('#blokChat').scrollTop($('#blokChat')[0].scrollHeight - $('#blokChat')[0].clientHeight);
	$("#refresh").click(function() { 
		$.get( "/shoutbox.php", function( data ) {
			  $("#blokChat").html( data );
			  $('#blokChat').scrollTop($('#blokChat')[0].scrollHeight - $('#blokChat')[0].clientHeight);
		});
	});
	$("#zapisz").click(function() {
		var mesg = $("#chat input[name='wiadomosc']").val();
		var user = $("#chat select[name='user']").val();

		if(mesg.length > 0)
		$.post( "/shoutbox.php", { USER: user, TEXT: mesg }, function( data ) {
			  $("#blokChat").html( data );
			  $("#chat input[name='wiadomosc']").val("");
			  $('#blokChat').scrollTop($('#blokChat')[0].scrollHeight - $('#blokChat')[0].clientHeight);
		});
	});
}); 
</script>