<?php
/* --------------------------------------------------------------------

  WebEngine
  http://lautaroangelico.com/webengine/

  @version	1.0.3
  @author	Lautaro Angélico <http://lautaroangelico.com/>
			<angelico.lautaro@gmail.com>

  Copyright (C) 2012-2013 Lautaro Angélico All rights reserved.

  --------------------------------------------------------------------- */

echo '
<div class="page-container">
	<div class="bg-module-title">
		<span class="title">'.lang('module_titles_txt_17',true).'</span>
		'.randMTBackground().'
	</div>
	<div class="page-content">';
	
		if(config('vip_enable',true)) {
			$Character = new Character();
			$VipSystem = new Vip();
			$AccountCharacters = $Character->AccountCharacter($_SESSION['username']);
			$AccountInfo = $common->accountInformation($_SESSION['userid']);
			
			if(is_array($AccountCharacters)) {
			
				// Vip Order Process
				if(check_value($_POST['submit'])) {
					$VipSystem->VipProcess($_SESSION['userid'],$_POST['vip_package']);
				}
				
				// Check if user has an active VIP subscription
				if($VipSystem->isVIP($_SESSION['userid'])) {
					message('warning',''.lang('vip_txt_1',true).'<b>'.$VipSystem->RemainingVIP($AccountInfo[_CLMN_VIP_STAMP_]).'</b>'.lang('vip_txt_2',true).'','INFO:');
					$button_txt = lang('vip_txt_3',true);
				} else {
					$button_txt = lang('vip_txt_4',true);
				}
				
				if(config('vip_show_benefits',true)) {
					$vip_benefits = config('vip_benefits',true);
					$benefits_list = '<ul>';
					foreach($vip_benefits as $thisBenefit) {
						$benefits_list .= '<li>'.$thisBenefit.'</li>';
					}
					$benefits_list .= '</ul>';
					message('','<br />'.$benefits_list.'',lang('vip_txt_5',true));
				}
				
				echo '
					<table class="general-table-ui" cellspacing="0">
						<tr>
							<td>'.lang('vip_txt_6',true).'</td>
							<td>'.lang('vip_txt_7',true).'</td>
							<td></td>
						</tr>';
						
					foreach(config('vip_plans',true) as $key => $vipPlan) {
						
						$discount = $vipPlan[1];
						$vipCost = $VipSystem->CalculatePlanCost($vipPlan[0],$discount);
						if($discount >= 1) {
							$discount_txt = '('.$discount.''.lang('vip_txt_8',true).')';
						}
						
						echo '
						<form action="" method="post">
						<input type="hidden" name="vip_package" value="'.Encode($key).'"/>
						<tr>
						<td>'.$vipPlan[0].' '.lang('vip_txt_9',true).'</td>
						<td>'.$vipCost.' '.lang('vip_txt_10',true).' '.$discount_txt.'</td>
						<td><input class="neon small box" type="submit" name="submit" value="'.$button_txt.'"/></a></td>
						</tr>
						</form>';
						
					}
						
				echo '</table>';
		
			} else {
				message('error', lang('error_46',true));
			}
		} else {
			message('error', lang('error_47',true));
		}
	
echo '	
	</div>
</div>
';