#include <allegro.h>
#include <math.h>
void init();
void deinit();
#define PI 3.1415926

int main() 
{
init();
BITMAP *bmp = create_bitmap(640, 400);
float y;
show_mouse(screen);
while (!key[KEY_ESC]) 
    {
    y=0;
    clear_bitmap(bmp);
    fastline(bmp,0, 180,640,180,makecol(250,0,0));
    for(int x=0;x<640;x++)
         {
          y=sin(x*PI/90);
          putpixel(bmp, x,(int)(y*90)+180, makecol(120,120,90));
          if((x % 20)==0)
             textprintf(bmp,font,x,(int)(y*90)+180,makecol(255,255,255),"y:%4.2f",(y)*-1);
         }
    blit(bmp, screen, 0, 0, 0, 0, 640, 400);
	}
destroy_bitmap(bmp);
deinit();
return 0;
}
END_OF_MAIN()

void init()
{
int depth, res;
allegro_init();
depth = desktop_color_depth();
if (depth == 0) depth = 32;
set_color_depth(depth);
res = set_gfx_mode(GFX_AUTODETECT_WINDOWED,640, 400, 0, 0);
if (res != 0) 
   {
		allegro_message(allegro_error);
		exit(-1);
   }
install_timer();
install_keyboard();
install_mouse();
}

void deinit() {
	clear_keybuf();
}
