/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.matrixJep;

import org.lsmp.djep.matrixJep.nodeTypes.ASTMConstant;
import org.lsmp.djep.matrixJep.nodeTypes.ASTMFunNode;
import org.lsmp.djep.matrixJep.nodeTypes.ASTMVarNode;
import org.lsmp.djep.matrixJep.nodeTypes.MatrixNodeI;
import org.lsmp.djep.vectorJep.Dimensions;
import org.lsmp.djep.vectorJep.function.BinaryOperatorI;
import org.lsmp.djep.vectorJep.function.NaryOperatorI;
import org.lsmp.djep.vectorJep.function.UnaryOperatorI;
import org.lsmp.djep.xjep.NodeFactory;
import org.nfunk.jep.ASTConstant;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.Node;
import org.nfunk.jep.Operator;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.Variable;
import org.nfunk.jep.function.PostfixMathCommandI;

public class MatrixNodeFactory
extends NodeFactory {
    public ASTConstant buildConstantNode(Object object) throws ParseException {
        ASTMConstant aSTMConstant = new ASTMConstant(4);
        aSTMConstant.setValue(object);
        return aSTMConstant;
    }

    public ASTVarNode buildVariableNode(Variable variable) throws ParseException {
        ASTMVarNode aSTMVarNode = new ASTMVarNode(3);
        aSTMVarNode.setVar(variable);
        return aSTMVarNode;
    }

    public ASTFunNode buildFunctionNode(String string, PostfixMathCommandI postfixMathCommandI, Node[] nodeArray) throws ParseException {
        ASTMFunNode aSTMFunNode = new ASTMFunNode(2);
        aSTMFunNode.setFunction(string, postfixMathCommandI);
        this.copyChildren(aSTMFunNode, nodeArray);
        aSTMFunNode.setDim(this.calcDim(string, postfixMathCommandI, nodeArray));
        return aSTMFunNode;
    }

    public Dimensions calcDim(String string, PostfixMathCommandI postfixMathCommandI, Node[] nodeArray) throws ParseException {
        MatrixNodeI[] matrixNodeIArray = new MatrixNodeI[nodeArray.length];
        for (int i = 0; i < nodeArray.length; ++i) {
            matrixNodeIArray[i] = (MatrixNodeI)nodeArray[i];
        }
        if (postfixMathCommandI instanceof BinaryOperatorI) {
            if (matrixNodeIArray.length != 2) {
                throw new ParseException("Operator " + string + " must have two elements, it has " + matrixNodeIArray.length);
            }
            BinaryOperatorI binaryOperatorI = (BinaryOperatorI)postfixMathCommandI;
            Dimensions dimensions = binaryOperatorI.calcDim(matrixNodeIArray[0].getDim(), matrixNodeIArray[1].getDim());
            return dimensions;
        }
        if (postfixMathCommandI instanceof UnaryOperatorI) {
            if (matrixNodeIArray.length != 1) {
                throw new ParseException("Operator " + string + " must have one elements, it has " + matrixNodeIArray.length);
            }
            UnaryOperatorI unaryOperatorI = (UnaryOperatorI)postfixMathCommandI;
            Dimensions dimensions = unaryOperatorI.calcDim(matrixNodeIArray[0].getDim());
            return dimensions;
        }
        if (postfixMathCommandI instanceof NaryOperatorI) {
            Dimensions[] dimensionsArray = new Dimensions[matrixNodeIArray.length];
            for (int i = 0; i < matrixNodeIArray.length; ++i) {
                dimensionsArray[i] = matrixNodeIArray[i].getDim();
            }
            NaryOperatorI naryOperatorI = (NaryOperatorI)postfixMathCommandI;
            Dimensions dimensions = naryOperatorI.calcDim(dimensionsArray);
            return dimensions;
        }
        return Dimensions.ONE;
    }

    public Dimensions calcDim(Operator operator, Node[] nodeArray) throws ParseException {
        return this.calcDim(operator.getName(), operator.getPFMC(), nodeArray);
    }

    public ASTFunNode buildFunctionNode(ASTFunNode aSTFunNode, Node[] nodeArray) throws ParseException {
        if (aSTFunNode instanceof ASTMFunNode) {
            if (aSTFunNode.isOperator()) {
                return this.buildOperatorNode(aSTFunNode.getOperator(), nodeArray, ((ASTMFunNode)aSTFunNode).getDim());
            }
            ASTMFunNode aSTMFunNode = new ASTMFunNode(2);
            aSTMFunNode.setFunction(aSTFunNode.getName(), aSTFunNode.getPFMC());
            this.copyChildren(aSTMFunNode, nodeArray);
            aSTMFunNode.setDim(((ASTMFunNode)aSTFunNode).getDim());
            return aSTMFunNode;
        }
        if (aSTFunNode.isOperator()) {
            return this.buildOperatorNode(aSTFunNode.getOperator(), nodeArray);
        }
        ASTMFunNode aSTMFunNode = new ASTMFunNode(2);
        aSTMFunNode.setFunction(aSTFunNode.getName(), aSTFunNode.getPFMC());
        this.copyChildren(aSTMFunNode, nodeArray);
        aSTMFunNode.setDim(this.calcDim(aSTFunNode.getName(), aSTFunNode.getPFMC(), nodeArray));
        return aSTMFunNode;
    }

    public ASTFunNode buildOperatorNode(Operator operator, Node[] nodeArray) throws ParseException {
        ASTMFunNode aSTMFunNode = new ASTMFunNode(2);
        aSTMFunNode.setOperator(operator);
        this.copyChildren(aSTMFunNode, nodeArray);
        aSTMFunNode.setDim(this.calcDim(operator, nodeArray));
        return aSTMFunNode;
    }

    public ASTFunNode buildOperatorNode(Operator operator, Node[] nodeArray, Dimensions dimensions) {
        ASTMFunNode aSTMFunNode = new ASTMFunNode(2);
        aSTMFunNode.setOperator(operator);
        aSTMFunNode.setDim(dimensions);
        this.copyChildren(aSTMFunNode, nodeArray);
        return aSTMFunNode;
    }

    public ASTFunNode buildUnfinishedOperatorNode(Operator operator) {
        ASTMFunNode aSTMFunNode = new ASTMFunNode(2);
        aSTMFunNode.setOperator(operator);
        return aSTMFunNode;
    }
}

