/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.matrixJep;

import org.lsmp.djep.djep.DSymbolTable;
import org.lsmp.djep.djep.Diff;
import org.lsmp.djep.matrixJep.MatrixJep;
import org.lsmp.djep.matrixJep.MatrixNodeFactory;
import org.lsmp.djep.matrixJep.MatrixOperatorSet;
import org.lsmp.djep.matrixJep.MatrixVariable;
import org.lsmp.djep.matrixJep.nodeTypes.ASTMFunNode;
import org.lsmp.djep.matrixJep.nodeTypes.ASTMVarNode;
import org.lsmp.djep.matrixJep.nodeTypes.MatrixNodeI;
import org.lsmp.djep.vectorJep.Dimensions;
import org.lsmp.djep.vectorJep.function.BinaryOperatorI;
import org.lsmp.djep.vectorJep.function.MPower;
import org.lsmp.djep.vectorJep.function.NaryOperatorI;
import org.lsmp.djep.vectorJep.function.UnaryOperatorI;
import org.lsmp.djep.xjep.CommandVisitorI;
import org.nfunk.jep.ASTConstant;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.ASTStart;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.Node;
import org.nfunk.jep.Operator;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.ParserVisitor;
import org.nfunk.jep.SimpleNode;
import org.nfunk.jep.function.Assign;
import org.nfunk.jep.function.List;
import org.nfunk.jep.function.PostfixMathCommandI;
import org.nfunk.jep.function.Power;

public class MatrixPreprocessor
implements ParserVisitor {
    private MatrixJep mjep;
    private MatrixNodeFactory nf;
    private MatrixOperatorSet opSet;
    private DSymbolTable vt;

    public MatrixNodeI preprocess(Node node, MatrixJep matrixJep) throws ParseException {
        this.mjep = matrixJep;
        this.nf = (MatrixNodeFactory)matrixJep.getNodeFactory();
        this.vt = (DSymbolTable)matrixJep.getSymbolTable();
        this.opSet = (MatrixOperatorSet)matrixJep.getOperatorSet();
        return (MatrixNodeI)node.jjtAccept((ParserVisitor)this, null);
    }

    public MatrixNodeI[] visitChildrenAsArray(Node node, Object object) throws ParseException {
        int n = node.jjtGetNumChildren();
        MatrixNodeI[] matrixNodeIArray = new MatrixNodeI[n];
        for (int i = 0; i < n; ++i) {
            MatrixNodeI matrixNodeI;
            matrixNodeIArray[i] = matrixNodeI = (MatrixNodeI)node.jjtGetChild(i).jjtAccept((ParserVisitor)this, object);
        }
        return matrixNodeIArray;
    }

    public Object visit(SimpleNode simpleNode, Object object) {
        return null;
    }

    public Object visit(ASTStart aSTStart, Object object) {
        return null;
    }

    public Object visit(ASTConstant aSTConstant, Object object) throws ParseException {
        return this.nf.buildConstantNode(aSTConstant.getValue());
    }

    public Object visit(ASTVarNode aSTVarNode, Object object) throws ParseException {
        return this.nf.buildVariableNode(this.vt.getVar(aSTVarNode.getName()));
    }

    public Object visit(ASTFunNode aSTFunNode, Object object) throws ParseException {
        if (aSTFunNode.isOperator()) {
            return this.visitOp(aSTFunNode, object);
        }
        if (aSTFunNode.getPFMC() instanceof Diff) {
            return this.visitDiff(aSTFunNode, object);
        }
        if (aSTFunNode.getPFMC() instanceof CommandVisitorI) {
            throw new IllegalArgumentException("MatrixPreprocessor: encounterd and instance of CommandVisitorI  for function " + aSTFunNode.getName());
        }
        Node[] nodeArray = this.visitChildrenAsArray((Node)aSTFunNode, object);
        ASTMFunNode aSTMFunNode = (ASTMFunNode)this.nf.buildFunctionNode(aSTFunNode, nodeArray);
        return aSTMFunNode;
    }

    public Object visitOp(ASTFunNode aSTFunNode, Object object) throws ParseException {
        PostfixMathCommandI postfixMathCommandI = aSTFunNode.getPFMC();
        Node[] nodeArray = this.visitChildrenAsArray((Node)aSTFunNode, object);
        if (postfixMathCommandI instanceof Assign) {
            if (aSTFunNode.jjtGetNumChildren() != 2) {
                throw new ParseException("Operator " + aSTFunNode.getOperator().getName() + " must have two elements, it has " + nodeArray.length);
            }
            Dimensions dimensions = nodeArray[1].getDim();
            MatrixVariable matrixVariable = (MatrixVariable)((ASTVarNode)nodeArray[0]).getVar();
            matrixVariable.setDimensions(dimensions);
            Node node = this.mjep.deepCopy(nodeArray[1]);
            Node node2 = this.mjep.simplify(node);
            matrixVariable.setEquation(node2);
            return (ASTMFunNode)this.nf.buildOperatorNode(aSTFunNode.getOperator(), nodeArray, dimensions);
        }
        if (postfixMathCommandI instanceof Power || postfixMathCommandI instanceof MPower) {
            if (aSTFunNode.jjtGetNumChildren() != 2) {
                throw new ParseException("Operator " + aSTFunNode.getOperator().getName() + " must have two elements, it has " + nodeArray.length);
            }
            Dimensions dimensions = nodeArray[0].getDim();
            Dimensions dimensions2 = nodeArray[1].getDim();
            if (dimensions2.equals(Dimensions.ONE)) {
                Dimensions dimensions3 = dimensions;
                return (ASTMFunNode)this.nf.buildOperatorNode(aSTFunNode.getOperator(), nodeArray, dimensions3);
            }
            Operator operator = this.opSet.getCross();
            PostfixMathCommandI postfixMathCommandI2 = operator.getPFMC();
            BinaryOperatorI binaryOperatorI = (BinaryOperatorI)postfixMathCommandI2;
            Dimensions dimensions4 = binaryOperatorI.calcDim(dimensions, dimensions2);
            return (ASTMFunNode)this.nf.buildOperatorNode(operator, nodeArray, dimensions4);
        }
        if (postfixMathCommandI instanceof List) {
            boolean bl = true;
            int n = 0;
            if (n < nodeArray.length) {
                if (nodeArray[n] instanceof ASTMFunNode) {
                    if (((ASTMFunNode)nodeArray[n]).getOperator() != this.opSet.getMList()) {
                        bl = false;
                    }
                } else {
                    bl = false;
                }
            }
            if (bl) {
                ASTMFunNode aSTMFunNode = (ASTMFunNode)nodeArray[0];
                Dimensions dimensions = Dimensions.valueOf(nodeArray.length, aSTMFunNode.getDim());
                ASTMFunNode aSTMFunNode2 = (ASTMFunNode)this.nf.buildUnfinishedOperatorNode(this.opSet.getMList());
                int n2 = 0;
                aSTMFunNode2.setDim(dimensions);
                aSTMFunNode2.jjtOpen();
                for (int i = 0; i < nodeArray.length; ++i) {
                    ASTMFunNode aSTMFunNode3 = (ASTMFunNode)nodeArray[i];
                    for (int j = 0; j < aSTMFunNode3.jjtGetNumChildren(); ++j) {
                        Node node = aSTMFunNode3.jjtGetChild(j);
                        aSTMFunNode2.jjtAddChild(node, n2++);
                        node.jjtSetParent((Node)aSTMFunNode2);
                    }
                }
                aSTMFunNode2.jjtClose();
                return aSTMFunNode2;
            }
            MatrixNodeI matrixNodeI = nodeArray[0];
            Dimensions dimensions = Dimensions.valueOf(nodeArray.length, matrixNodeI.getDim());
            ASTMFunNode aSTMFunNode = (ASTMFunNode)this.nf.buildOperatorNode(this.opSet.getMList(), nodeArray, dimensions);
            return aSTMFunNode;
        }
        if (postfixMathCommandI instanceof BinaryOperatorI) {
            if (aSTFunNode.jjtGetNumChildren() != 2) {
                throw new ParseException("Operator " + aSTFunNode.getOperator().getName() + " must have two elements, it has " + nodeArray.length);
            }
            BinaryOperatorI binaryOperatorI = (BinaryOperatorI)postfixMathCommandI;
            Dimensions dimensions = binaryOperatorI.calcDim(nodeArray[0].getDim(), nodeArray[1].getDim());
            return (ASTMFunNode)this.nf.buildOperatorNode(aSTFunNode.getOperator(), nodeArray, dimensions);
        }
        if (postfixMathCommandI instanceof UnaryOperatorI) {
            if (nodeArray.length != 1) {
                throw new ParseException("Operator " + aSTFunNode.getOperator().getName() + " must have one elements, it has " + nodeArray.length);
            }
            UnaryOperatorI unaryOperatorI = (UnaryOperatorI)postfixMathCommandI;
            Dimensions dimensions = unaryOperatorI.calcDim(nodeArray[0].getDim());
            return (ASTMFunNode)this.nf.buildOperatorNode(aSTFunNode.getOperator(), nodeArray, dimensions);
        }
        if (postfixMathCommandI instanceof NaryOperatorI) {
            Dimensions[] dimensionsArray = new Dimensions[nodeArray.length];
            for (int i = 0; i < nodeArray.length; ++i) {
                dimensionsArray[i] = nodeArray[i].getDim();
            }
            NaryOperatorI naryOperatorI = (NaryOperatorI)postfixMathCommandI;
            Dimensions dimensions = naryOperatorI.calcDim(dimensionsArray);
            return (ASTMFunNode)this.nf.buildOperatorNode(aSTFunNode.getOperator(), nodeArray, dimensions);
        }
        Dimensions dimensions = Dimensions.ONE;
        return (ASTMFunNode)this.nf.buildOperatorNode(aSTFunNode.getOperator(), nodeArray, dimensions);
    }

    public Object visitDiff(ASTFunNode aSTFunNode, Object object) throws ParseException {
        MatrixNodeI[] matrixNodeIArray = this.visitChildrenAsArray((Node)aSTFunNode, object);
        if (matrixNodeIArray.length != 2) {
            throw new ParseException("Diff opperator should have two children, it has " + matrixNodeIArray.length);
        }
        if (!(matrixNodeIArray[1] instanceof ASTMVarNode)) {
            throw new ParseException("rhs of diff opperator should be a variable.");
        }
        ASTMVarNode aSTMVarNode = (ASTMVarNode)matrixNodeIArray[1];
        Node node = this.mjep.differentiate(matrixNodeIArray[0], aSTMVarNode.getName());
        return node;
    }
}

