/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.rpe;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import org.lsmp.djep.rpe.RpCommandList;
import org.nfunk.jep.ASTConstant;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.ASTStart;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.JEP;
import org.nfunk.jep.Node;
import org.nfunk.jep.Operator;
import org.nfunk.jep.OperatorSet;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.ParserVisitor;
import org.nfunk.jep.SimpleNode;
import org.nfunk.jep.Variable;
import org.nfunk.jep.function.SpecialEvaluationI;

public final class RpEval
implements ParserVisitor {
    private JEP jep;
    private OperatorSet opSet;
    private ScalerStore scalerStore = new ScalerStore();
    private double[] constVals = new double[0];
    private RpCommandList curCommandList;
    static final short CONST = 0;
    static final short VAR = 1;
    static final short ADD = 2;
    static final short SUB = 3;
    static final short MUL = 4;
    static final short DIV = 5;
    static final short MOD = 6;
    static final short POW = 7;
    static final short AND = 8;
    static final short OR = 9;
    static final short NOT = 10;
    static final short LT = 11;
    static final short LE = 12;
    static final short GT = 13;
    static final short GE = 14;
    static final short NE = 15;
    static final short EQ = 16;
    static final short LIST = 17;
    static final short DOT = 18;
    static final short CROSS = 19;
    static final short ASSIGN = 20;
    static final short VLIST = 21;
    static final short MLIST = 22;
    static final short FUN = 23;
    static final short UMINUS = 24;
    private static final short SIN = 1;
    private static final short COS = 2;
    private static final short TAN = 3;
    private static final short ASIN = 4;
    private static final short ACOS = 5;
    private static final short ATAN = 6;
    private static final short SINH = 7;
    private static final short COSH = 8;
    private static final short TANH = 9;
    private static final short ASINH = 10;
    private static final short ACOSH = 11;
    private static final short ATANH = 12;
    private static final short ABS = 13;
    private static final short EXP = 14;
    private static final short LOG = 15;
    private static final short LN = 16;
    private static final short SQRT = 17;
    private static final short SEC = 18;
    private static final short COSEC = 19;
    private static final short COT = 20;
    private static final short ANGLE = 21;
    private static final short MODULUS = 22;
    private static final Hashtable functionHash = new Hashtable();
    private static final double LOG10 = Math.log(10.0);

    public RpEval(JEP jEP) {
        functionHash.put("sin", new Short(1));
        functionHash.put("cos", new Short(2));
        functionHash.put("tan", new Short(3));
        functionHash.put("asin", new Short(4));
        functionHash.put("acos", new Short(5));
        functionHash.put("atan", new Short(6));
        functionHash.put("sinh", new Short(7));
        functionHash.put("cosh", new Short(8));
        functionHash.put("tanh", new Short(9));
        functionHash.put("asinh", new Short(10));
        functionHash.put("acosh", new Short(11));
        functionHash.put("atanh", new Short(12));
        functionHash.put("abs", new Short(13));
        functionHash.put("exp", new Short(14));
        functionHash.put("log", new Short(15));
        functionHash.put("ln", new Short(16));
        functionHash.put("sqrt", new Short(17));
        functionHash.put("sec", new Short(18));
        functionHash.put("cosec", new Short(19));
        functionHash.put("cot", new Short(20));
        this.jep = jEP;
        this.opSet = jEP.getOperatorSet();
    }

    private RpEval() {
        functionHash.put("sin", new Short(1));
        functionHash.put("cos", new Short(2));
        functionHash.put("tan", new Short(3));
        functionHash.put("asin", new Short(4));
        functionHash.put("acos", new Short(5));
        functionHash.put("atan", new Short(6));
        functionHash.put("sinh", new Short(7));
        functionHash.put("cosh", new Short(8));
        functionHash.put("tanh", new Short(9));
        functionHash.put("asinh", new Short(10));
        functionHash.put("acosh", new Short(11));
        functionHash.put("atanh", new Short(12));
        functionHash.put("abs", new Short(13));
        functionHash.put("exp", new Short(14));
        functionHash.put("log", new Short(15));
        functionHash.put("ln", new Short(16));
        functionHash.put("sqrt", new Short(17));
        functionHash.put("sec", new Short(18));
        functionHash.put("cosec", new Short(19));
        functionHash.put("cot", new Short(20));
    }

    public final RpCommandList compile(Node node) throws ParseException {
        this.curCommandList = new RpCommandList();
        node.jjtAccept((ParserVisitor)this, null);
        this.scalerStore.alloc();
        return this.curCommandList;
    }

    public final Object visit(ASTStart aSTStart, Object object) throws ParseException {
        throw new ParseException("RpeEval: Start node encountered");
    }

    public final Object visit(SimpleNode simpleNode, Object object) throws ParseException {
        throw new ParseException("RpeEval: Simple node encountered");
    }

    public final Object visit(ASTConstant aSTConstant, Object object) throws ParseException {
        Object object2 = aSTConstant.getValue();
        if (!(object2 instanceof Double)) {
            throw new ParseException("RpeEval: only constants of double type allowed");
        }
        double d = (Double)aSTConstant.getValue();
        this.scalerStore.incStack();
        for (short s = 0; s < this.constVals.length; s = (short)(s + 1)) {
            if (d != this.constVals[s]) continue;
            this.curCommandList.addCommand((short)0, s);
            return null;
        }
        double[] dArray = new double[this.constVals.length + 1];
        System.arraycopy(this.constVals, 0, dArray, 0, this.constVals.length);
        dArray[this.constVals.length] = d;
        this.curCommandList.addCommand((short)0, (short)this.constVals.length);
        this.constVals = dArray;
        return null;
    }

    public final Object visit(ASTVarNode aSTVarNode, Object object) throws ParseException {
        Variable variable = aSTVarNode.getVar();
        short s = (short)this.scalerStore.addVar(variable);
        this.scalerStore.incStack();
        this.curCommandList.addCommand((short)1, s);
        return null;
    }

    public final Object visit(ASTFunNode aSTFunNode, Object object) throws ParseException {
        int n = aSTFunNode.jjtGetNumChildren();
        if (!(aSTFunNode.getPFMC() instanceof SpecialEvaluationI)) {
            aSTFunNode.childrenAccept((ParserVisitor)this, null);
        }
        if (aSTFunNode.isOperator()) {
            Operator operator = aSTFunNode.getOperator();
            if (operator == this.opSet.getAdd()) {
                this.curCommandList.addCommand((short)2);
                this.scalerStore.decStack();
                return null;
            }
            if (operator == this.opSet.getSubtract()) {
                this.curCommandList.addCommand((short)3);
                this.scalerStore.decStack();
                return null;
            }
            if (operator == this.opSet.getUMinus()) {
                this.curCommandList.addCommand((short)24);
                return null;
            }
            if (operator == this.opSet.getMultiply()) {
                this.scalerStore.decStack();
                this.curCommandList.addCommand((short)4);
                return null;
            }
            if (operator == this.opSet.getAssign()) {
                Node node = aSTFunNode.jjtGetChild(1);
                node.jjtAccept((ParserVisitor)this, null);
                Variable variable = ((ASTVarNode)aSTFunNode.jjtGetChild(0)).getVar();
                short s = (short)this.scalerStore.addVar(variable);
                this.scalerStore.decStack();
                this.curCommandList.addCommand((short)20, s);
                return null;
            }
            if (operator == this.opSet.getEQ()) {
                this.scalerStore.decStack();
                this.curCommandList.addCommand((short)16);
                return null;
            }
            if (operator == this.opSet.getNE()) {
                this.scalerStore.decStack();
                this.curCommandList.addCommand((short)15);
                return null;
            }
            if (operator == this.opSet.getLT()) {
                this.scalerStore.decStack();
                this.curCommandList.addCommand((short)11);
                return null;
            }
            if (operator == this.opSet.getGT()) {
                this.scalerStore.decStack();
                this.curCommandList.addCommand((short)13);
                return null;
            }
            if (operator == this.opSet.getLE()) {
                this.scalerStore.decStack();
                this.curCommandList.addCommand((short)12);
                return null;
            }
            if (operator == this.opSet.getGE()) {
                this.scalerStore.decStack();
                this.curCommandList.addCommand((short)14);
                return null;
            }
            if (operator == this.opSet.getAnd()) {
                this.scalerStore.decStack();
                this.curCommandList.addCommand((short)8);
                return null;
            }
            if (operator == this.opSet.getOr()) {
                this.scalerStore.decStack();
                this.curCommandList.addCommand((short)9);
                return null;
            }
            if (operator == this.opSet.getNot()) {
                this.curCommandList.addCommand((short)10);
                return null;
            }
            if (operator == this.opSet.getDivide()) {
                this.scalerStore.decStack();
                this.curCommandList.addCommand((short)5);
                return null;
            }
            if (operator == this.opSet.getMod()) {
                this.scalerStore.decStack();
                this.curCommandList.addCommand((short)6);
                return null;
            }
            if (operator == this.opSet.getPower()) {
                this.scalerStore.decStack();
                this.curCommandList.addCommand((short)7);
                return null;
            }
            throw new ParseException("RpeEval: Sorry unsupported operator/function: " + aSTFunNode.getName());
        }
        Short s = (Short)functionHash.get(aSTFunNode.getName());
        if (s == null) {
            throw new ParseException("RpeEval: Sorry unsupported operator/function: " + aSTFunNode.getName());
        }
        if (aSTFunNode.getPFMC().getNumberOfParameters() == 1 && n == 1) {
            this.curCommandList.addCommand((short)23, s);
            return null;
        }
        throw new ParseException("RpeEval: sorry can currently only support single argument functions");
    }

    public final double evaluate(RpCommandList rpCommandList) {
        this.scalerStore.reset();
        int n = rpCommandList.getNumCommands();
        block22: for (int n2 = 0; n2 < n; n2 = (int)((short)(n2 + 1))) {
            RpCommandList.RpCommand rpCommand = rpCommandList.commands[n2];
            short s = rpCommand.aux1;
            switch (rpCommand.command) {
                case 0: {
                    ((ScalerStore)this.scalerStore).stack[this.scalerStore.sp++] = this.constVals[s];
                    continue block22;
                }
                case 1: {
                    ((ScalerStore)this.scalerStore).stack[this.scalerStore.sp++] = this.scalerStore.vars[s];
                    continue block22;
                }
                case 2: {
                    this.scalerStore.add();
                    continue block22;
                }
                case 3: {
                    this.scalerStore.sub();
                    continue block22;
                }
                case 4: {
                    this.scalerStore.mulS();
                    continue block22;
                }
                case 5: {
                    this.scalerStore.div();
                    continue block22;
                }
                case 6: {
                    this.scalerStore.mod();
                    continue block22;
                }
                case 7: {
                    this.scalerStore.pow();
                    continue block22;
                }
                case 8: {
                    this.scalerStore.and();
                    continue block22;
                }
                case 9: {
                    this.scalerStore.or();
                    continue block22;
                }
                case 10: {
                    this.scalerStore.not();
                    continue block22;
                }
                case 11: {
                    this.scalerStore.lt();
                    continue block22;
                }
                case 12: {
                    this.scalerStore.le();
                    continue block22;
                }
                case 13: {
                    this.scalerStore.gt();
                    continue block22;
                }
                case 14: {
                    this.scalerStore.ge();
                    continue block22;
                }
                case 15: {
                    this.scalerStore.neq();
                    continue block22;
                }
                case 16: {
                    this.scalerStore.eq();
                    continue block22;
                }
                case 20: {
                    this.scalerStore.assign(s);
                    continue block22;
                }
                case 23: {
                    this.unitaryFunction(s);
                    continue block22;
                }
                case 24: {
                    this.scalerStore.uminus();
                }
            }
        }
        return this.scalerStore.stack[--this.scalerStore.sp];
    }

    private final void unitaryFunction(short s) {
        double d = this.scalerStore.stack[--this.scalerStore.sp];
        switch (s) {
            case 1: {
                d = Math.sin(d);
                break;
            }
            case 2: {
                d = Math.cos(d);
                break;
            }
            case 3: {
                d = Math.tan(d);
                break;
            }
            case 4: {
                d = Math.asin(d);
                break;
            }
            case 5: {
                d = Math.acos(d);
                break;
            }
            case 6: {
                d = Math.atan(d);
                break;
            }
            case 7: {
                d = (Math.exp(d) - Math.exp(-d)) / 2.0;
                break;
            }
            case 8: {
                d = (Math.exp(d) + Math.exp(-d)) / 2.0;
                break;
            }
            case 9: {
                double d2 = Math.exp(d * 2.0);
                d = (d2 - 1.0) / (d2 + 1.0);
                break;
            }
            case 10: {
                d = Math.log(d + Math.sqrt(1.0 + d * d));
                break;
            }
            case 11: {
                d = Math.log(d + Math.sqrt(d * d - 1.0));
                break;
            }
            case 12: {
                d = Math.log((1.0 + d) / (1.0 - d)) / 2.0;
                break;
            }
            case 13: {
                d = Math.abs(d);
                break;
            }
            case 14: {
                d = Math.exp(d);
                break;
            }
            case 15: {
                d = Math.log(d) / LOG10;
                break;
            }
            case 16: {
                d = Math.log(d);
                break;
            }
            case 17: {
                d = Math.sqrt(d);
                break;
            }
            case 18: {
                d = 1.0 / Math.cos(d);
                break;
            }
            case 19: {
                d = 1.0 / Math.sin(d);
                break;
            }
            case 20: {
                d = 1.0 / Math.tan(d);
            }
        }
        ((ScalerStore)this.scalerStore).stack[this.scalerStore.sp++] = d;
    }

    public void cleanUp() {
        this.scalerStore.cleanUp();
    }

    private final class ScalerStore
    extends ObjStore {
        private double[] stack = new double[0];
        private double[] vars = new double[0];

        private ScalerStore() {
        }

        final void alloc() {
            this.stack = new double[this.stackMax];
        }

        final void expandVarArray(int n) {
            double[] dArray = new double[n];
            System.arraycopy(this.vars, 0, dArray, 0, this.vars.length);
            this.vars = dArray;
        }

        final void copyFromVar(Variable variable, int n) {
            if (variable.hasValidValue()) {
                Double d = (Double)variable.getValue();
                this.vars[n] = d;
            }
        }

        final void add() {
            double d = this.stack[--this.sp];
            int n = this.sp - 1;
            this.stack[n] = this.stack[n] + d;
        }

        final void sub() {
            double d = this.stack[--this.sp];
            int n = this.sp - 1;
            this.stack[n] = this.stack[n] - d;
        }

        final void uminus() {
            double d = this.stack[--this.sp];
            this.stack[this.sp++] = -d;
        }

        final void mulS() {
            double d = this.stack[--this.sp];
            int n = this.sp - 1;
            this.stack[n] = this.stack[n] * d;
        }

        final void div() {
            double d = this.stack[--this.sp];
            int n = this.sp - 1;
            this.stack[n] = this.stack[n] / d;
        }

        final void mod() {
            double d = this.stack[--this.sp];
            int n = this.sp - 1;
            this.stack[n] = this.stack[n] % d;
        }

        final void pow() {
            double d = this.stack[--this.sp];
            double d2 = this.stack[--this.sp];
            this.stack[this.sp++] = Math.pow(d2, d);
        }

        final void powN(int n) {
            double d = this.stack[--this.sp];
            switch (n) {
                case 0: {
                    d = 1.0;
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    d *= d;
                    break;
                }
                case 3: {
                    d *= d * d;
                    break;
                }
                case 4: {
                    d *= d * d * d;
                    break;
                }
                case 5: {
                    d *= d * d * d * d;
                    break;
                }
                default: {
                    d = Math.pow(d, n);
                }
            }
            this.stack[this.sp++] = d;
        }

        final void assign(int n) {
            this.vars[n] = this.stack[--this.sp];
            ++this.sp;
        }

        final void and() {
            double d;
            double d2 = this.stack[--this.sp];
            this.stack[this.sp++] = (d = this.stack[--this.sp]) != 0.0 && d2 != 0.0 ? 1.0 : 0.0;
        }

        final void or() {
            double d;
            double d2 = this.stack[--this.sp];
            this.stack[this.sp++] = (d = this.stack[--this.sp]) != 0.0 || d2 != 0.0 ? 1.0 : 0.0;
        }

        final void not() {
            double d;
            this.stack[this.sp++] = (d = this.stack[--this.sp]) == 0.0 ? 1.0 : 0.0;
        }

        final void lt() {
            double d;
            double d2;
            this.stack[this.sp++] = (d2 = this.stack[--this.sp]) < (d = this.stack[--this.sp]) ? 1.0 : 0.0;
        }

        final void gt() {
            double d;
            double d2;
            this.stack[this.sp++] = (d2 = this.stack[--this.sp]) > (d = this.stack[--this.sp]) ? 1.0 : 0.0;
        }

        final void le() {
            double d;
            double d2;
            this.stack[this.sp++] = (d2 = this.stack[--this.sp]) <= (d = this.stack[--this.sp]) ? 1.0 : 0.0;
        }

        final void ge() {
            double d;
            double d2;
            this.stack[this.sp++] = (d2 = this.stack[--this.sp]) >= (d = this.stack[--this.sp]) ? 1.0 : 0.0;
        }

        final void eq() {
            double d;
            double d2;
            this.stack[this.sp++] = (d2 = this.stack[--this.sp]) == (d = this.stack[--this.sp]) ? 1.0 : 0.0;
        }

        final void neq() {
            double d;
            double d2;
            this.stack[this.sp++] = (d2 = this.stack[--this.sp]) != (d = this.stack[--this.sp]) ? 1.0 : 0.0;
        }
    }

    private static abstract class ObjStore
    implements Observer {
        Hashtable varRefs = new Hashtable();
        int sp = 0;
        int stackMax = 0;

        private ObjStore() {
        }

        final void incStack() {
            ++this.sp;
            if (this.sp > this.stackMax) {
                this.stackMax = this.sp;
            }
        }

        final void decStack() throws ParseException {
            --this.sp;
            if (this.sp < 0) {
                throw new ParseException("RPEval: stack error");
            }
        }

        final void reset() {
            this.sp = 0;
        }

        final int addVar(Variable variable) {
            Object v = this.varRefs.get(variable);
            if (v == null) {
                int n = this.varRefs.size();
                this.expandVarArray(n + 1);
                this.varRefs.put(variable, new Integer(n));
                this.copyFromVar(variable, n);
                variable.addObserver((Observer)this);
                return n;
            }
            return (Integer)v;
        }

        public final void update(Observable observable, Object object) {
            Variable variable = (Variable)observable;
            Object v = this.varRefs.get(variable);
            this.copyFromVar(variable, (Integer)v);
        }

        abstract void alloc();

        final void cleanUp() {
            Enumeration enumeration = this.varRefs.keys();
            while (enumeration.hasMoreElements()) {
                Variable variable = (Variable)enumeration.nextElement();
                variable.deleteObserver((Observer)this);
            }
            this.varRefs.clear();
        }

        abstract void copyFromVar(Variable var1, int var2);

        abstract void expandVarArray(int var1);

        abstract void add();

        abstract void sub();

        abstract void mulS();

        abstract void assign(int var1);
    }
}

