/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.xjep;

import java.util.Stack;
import org.lsmp.djep.xjep.XJep;
import org.lsmp.djep.xjep.XSymbolTable;
import org.nfunk.jep.EvaluatorVisitor;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.SymbolTable;
import org.nfunk.jep.Variable;
import org.nfunk.jep.function.PostfixMathCommand;

public class MacroFunction
extends PostfixMathCommand {
    private String name;
    private Node topNode;
    private EvaluatorVisitor ev = new EvaluatorVisitor();
    private XSymbolTable mySymTab;
    private Variable[] vars;

    public String getName() {
        return this.name;
    }

    public Node getTopNode() {
        return this.topNode;
    }

    public MacroFunction(String string, int n, String string2, XJep xJep) throws IllegalArgumentException, ParseException {
        this.name = string;
        XSymbolTable xSymbolTable = (XSymbolTable)xJep.getSymbolTable();
        this.mySymTab = (XSymbolTable)xSymbolTable.newInstance();
        this.mySymTab.copyConstants(xSymbolTable);
        XJep xJep2 = xJep.newInstance(this.mySymTab);
        this.numberOfParameters = n;
        if (this.numberOfParameters != 0) {
            if (this.numberOfParameters == 1) {
                this.vars = new Variable[]{this.mySymTab.addVariable("x", null)};
            } else if (this.numberOfParameters == 2) {
                this.vars = new Variable[]{this.mySymTab.addVariable("x", null), this.mySymTab.addVariable("y", null)};
            } else {
                this.vars = new Variable[this.numberOfParameters];
                int n2 = this.numberOfParameters - 1;
                while (n2 > 0) {
                    this.vars[n2] = this.mySymTab.addVariable("x" + String.valueOf(n2), null);
                }
            }
        }
        this.topNode = xJep2.parse(string2);
    }

    public void run(Stack stack) throws ParseException {
        if (this.numberOfParameters != 0) {
            if (this.numberOfParameters == 1) {
                this.vars[0].setValue(stack.pop());
            } else if (this.numberOfParameters == 2) {
                this.vars[1].setValue(stack.pop());
                this.vars[0].setValue(stack.pop());
            } else {
                int n = this.numberOfParameters - 1;
                while (n > 0) {
                    this.vars[n].setValue(stack.pop());
                }
            }
        }
        try {
            Object object = this.ev.getValue(this.topNode, null, (SymbolTable)this.mySymTab);
            stack.push(object);
        }
        catch (Exception exception) {
            throw new ParseException("MacroFunction eval: " + exception.getMessage());
        }
    }
}

