/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.groupJep.values;

import org.lsmp.djep.groupJep.GroupJep;
import org.lsmp.djep.groupJep.interfaces.RingI;
import org.nfunk.jep.type.Complex;

public class Polynomial
extends Number {
    private RingI baseRing;
    private String symbol;
    private Number[] coeffs;
    private int degree;

    public Polynomial(RingI ringI, String string, Number[] numberArray) {
        this.baseRing = ringI;
        this.symbol = string;
        int n = 0;
        for (int i = numberArray.length - 1; i > 0; --i) {
            if (ringI.equals(numberArray[i], ringI.getZERO())) continue;
            n = i;
            break;
        }
        if (n == numberArray.length - 1) {
            this.coeffs = numberArray;
        } else {
            this.coeffs = new Number[n + 1];
            System.arraycopy(numberArray, 0, this.coeffs, 0, n + 1);
        }
        this.degree = n;
    }

    protected void setCoeffs(Number[] numberArray) {
        this.coeffs = numberArray;
        this.degree = numberArray.length - 1;
    }

    protected Polynomial valueOf(Number[] numberArray) {
        Polynomial polynomial = new Polynomial(this.baseRing, this.symbol, numberArray);
        return polynomial;
    }

    public Polynomial add(Polynomial polynomial) {
        int n = this.degree > polynomial.degree ? this.degree : polynomial.degree;
        Number[] numberArray = new Number[n + 1];
        for (int i = 0; i <= n; ++i) {
            numberArray[i] = i <= this.degree && i <= polynomial.degree ? (Number)this.baseRing.add(this.coeffs[i], polynomial.coeffs[i]) : (Number)(i <= this.degree ? (Number)this.coeffs[i] : (Number)polynomial.coeffs[i]);
        }
        return this.valueOf(numberArray);
    }

    public Polynomial sub(Polynomial polynomial) {
        int n = this.degree > polynomial.degree ? this.degree : polynomial.degree;
        Number[] numberArray = new Number[n + 1];
        for (int i = 0; i <= n; ++i) {
            numberArray[i] = i <= this.degree && i <= polynomial.degree ? (Number)this.baseRing.sub(this.coeffs[i], polynomial.coeffs[i]) : (Number)(i <= this.degree ? (Number)this.coeffs[i] : (Number)this.baseRing.getInverse(polynomial.coeffs[i]));
        }
        return this.valueOf(numberArray);
    }

    public Polynomial mul(Polynomial polynomial) {
        int n;
        int n2 = this.degree + polynomial.degree;
        Number[] numberArray = new Number[n2 + 1];
        for (n = 0; n <= n2; ++n) {
            numberArray[n] = this.baseRing.getZERO();
        }
        for (n = 0; n <= this.degree; ++n) {
            for (int i = 0; i <= polynomial.degree; ++i) {
                numberArray[n + i] = this.baseRing.add(numberArray[n + i], this.baseRing.mul(this.coeffs[n], polynomial.coeffs[i]));
            }
        }
        return this.valueOf(numberArray);
    }

    private String stripBrackets(Number number) {
        String string = number.toString();
        if (string.startsWith("<") && string.endsWith(">")) {
            if (string.indexOf(43) != -1 || string.indexOf(45) > 1) {
                return string;
            }
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public String toString() {
        if (this.degree == 0) {
            return "<" + this.stripBrackets(this.coeffs[0]) + ">";
        }
        StringBuffer stringBuffer = new StringBuffer("<");
        for (int i = this.degree; i >= 0; --i) {
            String string = this.stripBrackets(this.coeffs[i]);
            if (string.equals("0") || this.baseRing.equals(this.coeffs[i], this.baseRing.getZERO())) continue;
            if (i != this.degree && !string.startsWith("-")) {
                stringBuffer.append("+");
            }
            if (i == 0) {
                String string2 = this.coeffs[i].toString();
                if (string2.startsWith("<") && string2.endsWith(">")) {
                    stringBuffer.append(string2.substring(1, string2.length() - 1));
                    break;
                }
                stringBuffer.append(string2);
                break;
            }
            if (string.equals("-1")) {
                stringBuffer.append("-");
            } else if (!string.equals("1") && !this.baseRing.equals(this.coeffs[i], this.baseRing.getONE())) {
                stringBuffer.append(this.stripBrackets(this.coeffs[i]));
                stringBuffer.append(" ");
            }
            if (i >= 2) {
                stringBuffer.append(this.symbol + "^" + i);
                continue;
            }
            if (i != 1) continue;
            stringBuffer.append(this.symbol);
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    public int getDegree() {
        return this.degree;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public Number[] getCoeffs() {
        return this.coeffs;
    }

    public Number getCoeff(int n) {
        return this.coeffs[n];
    }

    public RingI getBaseRing() {
        return this.baseRing;
    }

    public int intValue() {
        return this.coeffs[0].intValue();
    }

    public long longValue() {
        return this.coeffs[0].longValue();
    }

    public float floatValue() {
        return this.coeffs[0].floatValue();
    }

    public double doubleValue() {
        return this.coeffs[0].doubleValue();
    }

    public boolean equals(Polynomial polynomial) {
        if (this.getDegree() != polynomial.getDegree()) {
            return false;
        }
        for (int i = 0; i <= this.getDegree(); ++i) {
            if (this.baseRing.equals(this.getCoeff(i), polynomial.getCoeff(i))) continue;
            return false;
        }
        return true;
    }

    public Complex calculateComplexValue(Complex complex) {
        Number number = this.coeffs[this.getDegree()];
        Complex complex2 = GroupJep.getComplexValue(number);
        for (int i = this.getDegree() - 1; i >= 0; --i) {
            Number number2 = this.coeffs[i];
            Complex complex3 = GroupJep.getComplexValue(number2);
            Complex complex4 = complex2.mul(complex);
            complex2 = complex4.add(complex3);
        }
        return complex2;
    }
}

