/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.groupJep.values;

import java.math.BigInteger;

public class Rational
extends Number
implements Comparable {
    private BigInteger numerator;
    private BigInteger denominator;

    private Rational() {
    }

    public Rational(BigInteger bigInteger) {
        this.numerator = bigInteger;
        this.denominator = BigInteger.ONE;
    }

    public Rational(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = bigInteger.gcd(bigInteger2);
        if (bigInteger3.equals(BigInteger.ZERO)) {
            this.numerator = this.denominator = BigInteger.ZERO;
        } else if (bigInteger2.signum() > 0) {
            this.numerator = bigInteger.divide(bigInteger3);
            this.denominator = bigInteger2.divide(bigInteger3);
        } else {
            this.numerator = bigInteger.divide(bigInteger3).negate();
            this.denominator = bigInteger2.divide(bigInteger3).negate();
        }
    }

    public int intValue() {
        if (this.denominator.equals(BigInteger.ZERO)) {
            int n = this.numerator.signum();
            if (n == 0) {
                return Integer.MAX_VALUE;
            }
            if (n > 0) {
                return Integer.MAX_VALUE;
            }
            return Integer.MIN_VALUE;
        }
        return this.numerator.divide(this.denominator).intValue();
    }

    public long longValue() {
        return this.numerator.divide(this.denominator).longValue();
    }

    public float floatValue() {
        if (this.denominator.equals(BigInteger.ZERO)) {
            int n = this.numerator.signum();
            if (n == 0) {
                return Float.NaN;
            }
            if (n > 0) {
                return Float.POSITIVE_INFINITY;
            }
            return Float.NEGATIVE_INFINITY;
        }
        return this.numerator.divide(this.denominator).floatValue();
    }

    public double doubleValue() {
        if (this.denominator.equals(BigInteger.ZERO)) {
            int n = this.numerator.signum();
            if (n == 0) {
                return Double.NaN;
            }
            if (n > 0) {
                return Double.POSITIVE_INFINITY;
            }
            return Double.NEGATIVE_INFINITY;
        }
        return this.numerator.divide(this.denominator).doubleValue();
    }

    public Rational add(Rational rational) {
        BigInteger bigInteger = this.numerator.multiply(rational.denominator);
        BigInteger bigInteger2 = this.denominator.multiply(rational.numerator);
        BigInteger bigInteger3 = this.denominator.multiply(rational.denominator);
        BigInteger bigInteger4 = bigInteger.add(bigInteger2);
        return new Rational(bigInteger4, bigInteger3);
    }

    public Rational sub(Rational rational) {
        BigInteger bigInteger = this.numerator.multiply(rational.denominator);
        BigInteger bigInteger2 = this.denominator.multiply(rational.numerator);
        BigInteger bigInteger3 = this.denominator.multiply(rational.denominator);
        BigInteger bigInteger4 = bigInteger.subtract(bigInteger2);
        return new Rational(bigInteger4, bigInteger3);
    }

    public Rational mul(Rational rational) {
        BigInteger bigInteger = this.numerator.multiply(rational.numerator);
        BigInteger bigInteger2 = this.denominator.multiply(rational.denominator);
        return new Rational(bigInteger, bigInteger2);
    }

    public Rational div(Rational rational) {
        BigInteger bigInteger = this.numerator.multiply(rational.denominator);
        BigInteger bigInteger2 = this.denominator.multiply(rational.numerator);
        return new Rational(bigInteger, bigInteger2);
    }

    public Rational pow(Rational rational) {
        if (!rational.denominator.equals(BigInteger.ONE)) {
            throw new ArithmeticException("Can only raise rationals to integer powers");
        }
        int n = rational.numerator.intValue();
        if (n == 0) {
            return new Rational(BigInteger.ONE);
        }
        if (n > 0) {
            BigInteger bigInteger = this.numerator.pow(n);
            BigInteger bigInteger2 = this.denominator.pow(n);
            return new Rational(bigInteger, bigInteger2);
        }
        BigInteger bigInteger = this.numerator.pow(-n);
        BigInteger bigInteger3 = this.denominator.pow(-n);
        return new Rational(bigInteger3, bigInteger);
    }

    public Rational negate() {
        return new Rational(this.numerator.negate(), this.denominator);
    }

    public Rational inverse() {
        return new Rational(this.denominator, this.numerator);
    }

    public static Number valueOf(String string) {
        int n = string.indexOf(47);
        if (n == -1) {
            return new Rational(new BigInteger(string));
        }
        return new Rational(new BigInteger(string.substring(n - 1)), new BigInteger(string.substring(n + 1, -1)));
    }

    public BigInteger getDenominator() {
        return this.denominator;
    }

    public BigInteger getNumerator() {
        return this.numerator;
    }

    public String toString() {
        if (this.denominator.equals(BigInteger.ONE)) {
            return this.numerator.toString();
        }
        return this.numerator.toString() + "/" + this.denominator.toString();
    }

    public int compareTo(Object object) {
        Rational rational = (Rational)object;
        if (this.denominator.compareTo(rational.denominator) == 0) {
            return this.numerator.compareTo(rational.numerator);
        }
        BigInteger bigInteger = this.numerator.multiply(rational.denominator);
        BigInteger bigInteger2 = this.denominator.multiply(rational.numerator);
        return bigInteger.compareTo(bigInteger2);
    }
}

