/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.xjep.function;

import java.util.Stack;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.ParserVisitor;
import org.nfunk.jep.Variable;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.function.SpecialEvaluationI;

public abstract class SumType
extends PostfixMathCommand
implements SpecialEvaluationI {
    protected String name;

    public SumType(String string) {
        this.numberOfParameters = -1;
        this.name = string;
    }

    public SumType() {
        this.numberOfParameters = -1;
    }

    public Object evaluate(Node node, Object object, ParserVisitor parserVisitor, Stack stack) throws ParseException {
        int n = node.jjtGetNumChildren();
        if (n < 4 || n > 5) {
            throw new ParseException(this.name + ": called with invalid number of parameters: " + n + " it should be either 4 or 5.");
        }
        Node node2 = node.jjtGetChild(1);
        Variable variable = null;
        if (!(node2 instanceof ASTVarNode)) {
            throw new ParseException(this.name + ": second argument should be a variable");
        }
        variable = ((ASTVarNode)node2).getVar();
        node.jjtGetChild(2).jjtAccept(parserVisitor, object);
        this.checkStack(stack);
        Object e = stack.pop();
        if (!(e instanceof Number)) {
            throw new ParseException(this.name + ": third argument (min) should evaluate to a number it is " + e.toString());
        }
        double d = ((Number)e).doubleValue();
        node.jjtGetChild(3).jjtAccept(parserVisitor, object);
        this.checkStack(stack);
        Object e2 = stack.pop();
        if (!(e2 instanceof Number)) {
            throw new ParseException(this.name + ": forth argument (max) should evaluate to a number it is " + e.toString());
        }
        double d2 = ((Number)e2).doubleValue();
        if (d > d2) {
            throw new ParseException(this.name + ": min value should be smaller than max value they are " + d + " and " + d2 + ".");
        }
        if (n == 5) {
            node.jjtGetChild(3).jjtAccept(parserVisitor, object);
            this.checkStack(stack);
            Object e3 = stack.pop();
            if (!(e3 instanceof Number)) {
                throw new ParseException(this.name + ": fifth argument (steps) should evaluate to a number it is " + e.toString());
            }
            double d3 = ((Number)e3).doubleValue();
            this.evaluate(node.jjtGetChild(0), variable, d, d2, d3, object, parserVisitor, stack);
        } else {
            this.evaluate(node, variable, d, d2, 1.0, object, parserVisitor, stack);
        }
        return null;
    }

    public Object evaluate(Node node, Variable variable, double d, double d2, double d3, Object object, ParserVisitor parserVisitor, Stack stack) throws ParseException {
        int n = 0;
        Object[] objectArray = new Object[(int)((d2 - d) / d3) + 1];
        n = 0;
        double d4 = d;
        while (d4 <= d2) {
            variable.setValue((Object)new Double(d4));
            node.jjtGetChild(0).jjtAccept(parserVisitor, object);
            this.checkStack(stack);
            objectArray[n] = stack.pop();
            d4 = d + (double)(++n) * d3;
        }
        Object object2 = this.evaluate(objectArray);
        stack.push(object2);
        return object2;
    }

    public abstract Object evaluate(Object[] var1) throws ParseException;

    public void run(Stack stack) throws ParseException {
        throw new ParseException(this.name + ": run method called should not normally happen.");
    }
}

