/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.djep;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import org.lsmp.djep.djep.DJep;
import org.lsmp.djep.djep.PartialDerivative;
import org.lsmp.djep.xjep.PrintVisitor;
import org.lsmp.djep.xjep.XVariable;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;

public class DVariable
extends XVariable {
    protected Hashtable derivatives = new Hashtable();

    protected PartialDerivative createDerivative(String[] stringArray, Node node) {
        return new PartialDerivative(this, stringArray, node);
    }

    protected DVariable(String string) {
        super(string);
    }

    protected DVariable(String string, Object object) {
        super(string, object);
    }

    public void setEquation(Node node) {
        super.setEquation(node);
        this.derivatives.clear();
    }

    public void invalidateAll() {
        this.setValidValue(false);
        Enumeration enumeration = this.derivatives.elements();
        while (enumeration.hasMoreElements()) {
            PartialDerivative partialDerivative = (PartialDerivative)enumeration.nextElement();
            partialDerivative.setValidValue(false);
        }
    }

    public static String makeDerivString(String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('d');
        if (stringArray.length != 1) {
            stringBuffer.append("^" + stringArray.length);
        }
        stringBuffer.append(string);
        stringBuffer.append('/');
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append('d');
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    private String[] sortedNames(String[] stringArray) {
        Object[] objectArray = new String[stringArray.length];
        System.arraycopy(stringArray, 0, objectArray, 0, stringArray.length);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public void setDerivative(String[] stringArray, PartialDerivative partialDerivative) {
        String[] stringArray2 = this.sortedNames(stringArray);
        this.derivatives.put(DVariable.makeDerivString(this.name, stringArray2), partialDerivative);
    }

    public void setDerivativeSorted(String[] stringArray, PartialDerivative partialDerivative) {
        this.derivatives.put(DVariable.makeDerivString(this.name, stringArray), partialDerivative);
    }

    public PartialDerivative getDerivative(String[] stringArray) {
        String[] stringArray2 = this.sortedNames(stringArray);
        return (PartialDerivative)this.derivatives.get(DVariable.makeDerivString(this.name, stringArray2));
    }

    public PartialDerivative getDerivativeSorted(String[] stringArray) {
        return (PartialDerivative)this.derivatives.get(DVariable.makeDerivString(this.name, stringArray));
    }

    public PartialDerivative findDerivativeSorted(String[] stringArray, DJep dJep) throws ParseException {
        Node node;
        Node node2;
        if (this.getEquation() == null) {
            return null;
        }
        if (stringArray == null) {
            throw new ParseException("findDerivativeSorted: Null array of names");
        }
        PartialDerivative partialDerivative = this.getDerivativeSorted(stringArray);
        if (partialDerivative != null) {
            return partialDerivative;
        }
        int n = stringArray.length;
        if (n < 1) {
            throw new ParseException("findDerivativeSorted: Empty Array of names");
        }
        if (n == 1) {
            node2 = this.getEquation();
        } else {
            node = new String[n - 1];
            for (int i = 0; i < n - 1; ++i) {
                node[i] = stringArray[i];
            }
            node2 = this.findDerivativeSorted((String[])node, dJep).getEquation();
        }
        if (node2 == null) {
            return null;
        }
        node = dJep.differentiate(node2, stringArray[n - 1]);
        Node node3 = dJep.simplify(node);
        partialDerivative = this.createDerivative(stringArray, node3);
        this.setDerivative(stringArray, partialDerivative);
        return partialDerivative;
    }

    public PartialDerivative findDerivative(String[] stringArray, DJep dJep) throws ParseException {
        String[] stringArray2 = this.sortedNames(stringArray);
        return this.findDerivativeSorted(stringArray2, dJep);
    }

    public PartialDerivative findDerivative(String string, DJep dJep) throws ParseException {
        String[] stringArray = new String[]{string};
        return this.findDerivativeSorted(stringArray, dJep);
    }

    public PartialDerivative findDerivative(PartialDerivative partialDerivative, String string, DJep dJep) throws ParseException {
        int n = partialDerivative.getDnames().length;
        String[] stringArray = new String[n + 1];
        System.arraycopy(partialDerivative.getDnames(), 0, stringArray, 0, n);
        stringArray[n] = string;
        return this.findDerivative(stringArray, dJep);
    }

    public void print(PrintVisitor printVisitor) {
        StringBuffer stringBuffer = new StringBuffer(this.name);
        stringBuffer.append(": ");
        if (this.hasValidValue()) {
            stringBuffer.append(" val " + this.getValue());
        } else {
            stringBuffer.append(" val invalid");
        }
        stringBuffer.append(" ");
        if (this.getEquation() != null) {
            stringBuffer.append(printVisitor.toString(this.getEquation()));
        }
        stringBuffer.append("\n");
        Enumeration enumeration = this.derivatives.elements();
        while (enumeration.hasMoreElements()) {
            PartialDerivative partialDerivative = (PartialDerivative)enumeration.nextElement();
            stringBuffer.append("\t" + partialDerivative.toString() + ": ");
            if (partialDerivative.hasValidValue()) {
                stringBuffer.append(" val " + partialDerivative.getValue());
            } else {
                stringBuffer.append(" val invalid");
            }
            stringBuffer.append(" ");
            stringBuffer.append(printVisitor.toString(partialDerivative.getEquation()));
            stringBuffer.append("\n");
        }
        System.out.print(stringBuffer.toString());
    }
}

