/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.djep;

import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.lsmp.djep.djep.DJep;
import org.lsmp.djep.djep.DVariable;
import org.lsmp.djep.djep.DiffRulesI;
import org.lsmp.djep.djep.PartialDerivative;
import org.lsmp.djep.djep.diffRules.AdditionDiffRule;
import org.lsmp.djep.djep.diffRules.DivideDiffRule;
import org.lsmp.djep.djep.diffRules.MacroDiffRules;
import org.lsmp.djep.djep.diffRules.MacroFunctionDiffRules;
import org.lsmp.djep.djep.diffRules.MultiplyDiffRule;
import org.lsmp.djep.djep.diffRules.PassThroughDiffRule;
import org.lsmp.djep.djep.diffRules.PowerDiffRule;
import org.lsmp.djep.djep.diffRules.SubtractDiffRule;
import org.lsmp.djep.xjep.DeepCopyVisitor;
import org.lsmp.djep.xjep.MacroFunction;
import org.lsmp.djep.xjep.NodeFactory;
import org.lsmp.djep.xjep.TreeUtils;
import org.nfunk.jep.ASTConstant;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.ParserVisitor;
import org.nfunk.jep.Variable;
import org.nfunk.jep.function.Exp;
import org.nfunk.jep.function.PostfixMathCommandI;

public class DifferentiationVisitor
extends DeepCopyVisitor {
    private static final boolean DEBUG = false;
    private DJep localDJep;
    private DJep globalDJep;
    private NodeFactory nf;
    private TreeUtils tu;
    Hashtable diffRules = new Hashtable();

    public DifferentiationVisitor(DJep dJep) {
        this.globalDJep = dJep;
        this.addDiffRule(new AdditionDiffRule("+"));
        this.addDiffRule(new SubtractDiffRule("-"));
        this.addDiffRule(new MultiplyDiffRule("*"));
        this.addDiffRule(new DivideDiffRule("/"));
        this.addDiffRule(new PowerDiffRule("^"));
        this.addDiffRule(new PassThroughDiffRule("UMinus", this.globalDJep.getOperatorSet().getUMinus().getPFMC()));
    }

    boolean addStandardDiffRules() {
        try {
            this.addDiffRule(new MacroDiffRules(this.globalDJep, "sin", "cos(x)"));
            this.addDiffRule(new MacroDiffRules(this.globalDJep, "cos", "-sin(x)"));
            this.addDiffRule(new MacroDiffRules(this.globalDJep, "tan", "1/((cos(x))^2)"));
            MacroFunction macroFunction = new MacroFunction("sec", 1, "1/cos(x)", this.globalDJep);
            this.globalDJep.addFunction("sec", (PostfixMathCommandI)macroFunction);
            MacroFunction macroFunction2 = new MacroFunction("cosec", 1, "1/sin(x)", this.globalDJep);
            this.globalDJep.addFunction("cosec", (PostfixMathCommandI)macroFunction2);
            MacroFunction macroFunction3 = new MacroFunction("cot", 1, "1/tan(x)", this.globalDJep);
            this.globalDJep.addFunction("cot", (PostfixMathCommandI)macroFunction3);
            this.addDiffRule(new MacroDiffRules(this.globalDJep, "sec", "sec(x) * tan(x)"));
            this.addDiffRule(new MacroDiffRules(this.globalDJep, "cosec", "-cosec(x) * cot(x)"));
            this.addDiffRule(new MacroDiffRules(this.globalDJep, "cot", "-(cosec(x))^2"));
            this.addDiffRule(new MacroDiffRules(this.globalDJep, "asin", "1/(sqrt(1-x^2))"));
            this.addDiffRule(new MacroDiffRules(this.globalDJep, "acos", "-1/(sqrt(1-x^2))"));
            this.addDiffRule(new MacroDiffRules(this.globalDJep, "atan", "1/(1+x^2)"));
            this.addDiffRule(new MacroDiffRules(this.globalDJep, "sinh", "cosh(x)"));
            this.addDiffRule(new MacroDiffRules(this.globalDJep, "cosh", "sinh(x)"));
            this.addDiffRule(new MacroDiffRules(this.globalDJep, "tanh", "1-(tanh(x))^2"));
            this.addDiffRule(new MacroDiffRules(this.globalDJep, "asinh", "1/(sqrt(1+x^2))"));
            this.addDiffRule(new MacroDiffRules(this.globalDJep, "acosh", "1/(sqrt(x^2-1))"));
            this.addDiffRule(new MacroDiffRules(this.globalDJep, "atanh", "1/(1-x^2)"));
            this.addDiffRule(new MacroDiffRules(this.globalDJep, "sqrt", "1/(2 (sqrt(x)))"));
            this.globalDJep.addFunction("exp", (PostfixMathCommandI)new Exp());
            this.addDiffRule(new MacroDiffRules(this.globalDJep, "exp", "exp(x)"));
            this.addDiffRule(new MacroDiffRules(this.globalDJep, "ln", "1/x"));
            this.addDiffRule(new MacroDiffRules(this.globalDJep, "log", (Node)this.globalDJep.getNodeFactory().buildOperatorNode(this.globalDJep.getOperatorSet().getDivide(), (Node)this.globalDJep.getNodeFactory().buildConstantNode(this.globalDJep.getTreeUtils().getNumber(1.0 / Math.log(10.0))), (Node)this.globalDJep.getNodeFactory().buildVariableNode(this.globalDJep.getSymbolTable().makeVarIfNeeded("x")))));
            this.addDiffRule(new MacroDiffRules(this.globalDJep, "abs", "abs(x)/x"));
            this.addDiffRule(new MacroDiffRules(this.globalDJep, "angle", "y/(x^2+y^2)", "-x/(x^2+y^2)"));
            this.addDiffRule(new MacroDiffRules(this.globalDJep, "mod", "1", "0"));
            this.addDiffRule(new PassThroughDiffRule(this.globalDJep, "sum"));
            this.addDiffRule(new PassThroughDiffRule(this.globalDJep, "re"));
            this.addDiffRule(new PassThroughDiffRule(this.globalDJep, "im"));
            this.addDiffRule(new PassThroughDiffRule(this.globalDJep, "rand"));
            MacroFunction macroFunction4 = new MacroFunction("macrocomplex", 2, "x+i*y", this.globalDJep);
            this.globalDJep.addFunction("macrocomplex", (PostfixMathCommandI)macroFunction4);
            this.addDiffRule(new MacroFunctionDiffRules(this.globalDJep, macroFunction4));
            return true;
        }
        catch (ParseException parseException) {
            System.err.println(parseException.getMessage());
            return false;
        }
    }

    void addDiffRule(DiffRulesI diffRulesI) {
        this.diffRules.put(diffRulesI.getName(), diffRulesI);
    }

    DiffRulesI getDiffRule(String string) {
        return (DiffRulesI)this.diffRules.get(string);
    }

    public void printDiffRules() {
        this.printDiffRules(System.out);
    }

    public void printDiffRules(PrintStream printStream) {
        Object object;
        String string;
        printStream.println("Standard Functions and their derivatives");
        Enumeration enumeration = this.globalDJep.getFunctionTable().keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            object = this.globalDJep.getFunctionTable().get(string);
            DiffRulesI diffRulesI = (DiffRulesI)this.diffRules.get(string);
            if (diffRulesI == null) {
                printStream.print(string + " No diff rules specified (" + object.getNumberOfParameters() + " arguments).");
            } else {
                printStream.print(((Object)diffRulesI).toString());
            }
            printStream.println();
        }
        enumeration = this.diffRules.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            object = (DiffRulesI)this.diffRules.get(string);
            if (this.globalDJep.getFunctionTable().containsKey((Object)string)) continue;
            printStream.print(object.toString());
            printStream.println("\tnot in JEP function list");
        }
    }

    public Node differentiate(Node node, String string, DJep dJep) throws ParseException, IllegalArgumentException {
        this.localDJep = dJep;
        this.nf = dJep.getNodeFactory();
        this.tu = dJep.getTreeUtils();
        if (node == null) {
            throw new IllegalArgumentException("node parameter is null");
        }
        if (string == null) {
            throw new IllegalArgumentException("var parameter is null");
        }
        Node node2 = (Node)node.jjtAccept((ParserVisitor)this, (Object)string);
        return node2;
    }

    public Object visit(ASTFunNode aSTFunNode, Object object) throws ParseException {
        String string = aSTFunNode.getName();
        Node[] nodeArray = TreeUtils.getChildrenAsArray((Node)aSTFunNode);
        Node[] nodeArray2 = this.acceptChildrenAsArray((Node)aSTFunNode, object);
        if (aSTFunNode.getPFMC() instanceof DiffRulesI) {
            return ((DiffRulesI)aSTFunNode.getPFMC()).differentiate(aSTFunNode, (String)object, nodeArray, nodeArray2, this.localDJep);
        }
        DiffRulesI diffRulesI = (DiffRulesI)this.diffRules.get(string);
        if (diffRulesI != null) {
            return diffRulesI.differentiate(aSTFunNode, (String)object, nodeArray, nodeArray2, this.localDJep);
        }
        throw new ParseException("Sorry I don't know how to differentiate " + aSTFunNode + "\n");
    }

    public Object visit(ASTVarNode aSTVarNode, Object object) throws ParseException {
        String string = (String)object;
        Variable variable = aSTVarNode.getVar();
        if (variable instanceof DVariable) {
            DVariable dVariable = (DVariable)variable;
            if (string.equals(variable.getName())) {
                return this.nf.buildConstantNode(this.tu.getONE());
            }
            if (dVariable.hasEquation()) {
                PartialDerivative partialDerivative = dVariable.findDerivative((String)object, this.localDJep);
                return this.nf.buildVariableNode(partialDerivative);
            }
            return this.nf.buildConstantNode(this.tu.getZERO());
        }
        if (variable instanceof PartialDerivative) {
            PartialDerivative partialDerivative = (PartialDerivative)variable;
            DVariable dVariable = partialDerivative.getRoot();
            PartialDerivative partialDerivative2 = dVariable.findDerivative(partialDerivative, string, this.localDJep);
            return this.nf.buildVariableNode(partialDerivative2);
        }
        throw new ParseException("Encountered non differentiable variable");
    }

    public Object visit(ASTConstant aSTConstant, Object object) throws ParseException {
        return this.nf.buildConstantNode(this.tu.getZERO());
    }
}

