/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.vectorJep;

public class Dimensions {
    private int[] dims;
    public static final Dimensions ONE = new Dimensions(1);
    public static final Dimensions TWO = new Dimensions(2);
    public static final Dimensions THREE = new Dimensions(3);

    private Dimensions() {
    }

    private Dimensions(int n) {
        this.dims = new int[]{n};
    }

    private Dimensions(int n, int n2) {
        this.dims = new int[]{n, n2};
    }

    private Dimensions(int[] nArray) {
        this.dims = new int[nArray.length];
        System.arraycopy(nArray, 0, this.dims, 0, nArray.length);
    }

    public static Dimensions valueOf(int n) {
        switch (n) {
            case 1: {
                return ONE;
            }
            case 2: {
                return TWO;
            }
            case 3: {
                return THREE;
            }
        }
        return new Dimensions(n);
    }

    public static Dimensions valueOf(int n, int n2) {
        return new Dimensions(n, n2);
    }

    public static Dimensions valueOf(int n, Dimensions dimensions) {
        Dimensions dimensions2 = new Dimensions();
        dimensions2.dims = new int[dimensions.rank() + 1];
        dimensions2.dims[0] = n;
        for (int i = 0; i < dimensions.rank(); ++i) {
            dimensions2.dims[i + 1] = dimensions.dims[i];
        }
        return dimensions2;
    }

    public static Dimensions valueOf(Dimensions dimensions, int n) {
        Dimensions dimensions2 = new Dimensions();
        dimensions2.dims = new int[dimensions.rank() + 1];
        for (int i = 0; i < dimensions.rank(); ++i) {
            dimensions2.dims[i] = dimensions.dims[i];
        }
        dimensions2.dims[dimensions.rank() + 1] = n;
        return dimensions2;
    }

    public static Dimensions valueOf(int[] nArray) {
        if (nArray.length == 1) {
            return Dimensions.valueOf(nArray[0]);
        }
        if (nArray.length == 2) {
            return Dimensions.valueOf(nArray[0], nArray[1]);
        }
        return new Dimensions(nArray);
    }

    public int getFirstDim() {
        return this.dims[0];
    }

    public int getLastDim() {
        return this.dims[this.dims.length - 1];
    }

    public int getIthDim(int n) {
        return this.dims[n];
    }

    public boolean is0D() {
        return this.dims.length == 1 && this.dims[0] == 1;
    }

    public boolean is1D() {
        return this.dims.length == 1 && this.dims[0] != 1;
    }

    public boolean is2D() {
        return this.dims.length == 2;
    }

    public int numEles() {
        int n = 1;
        for (int i = 0; i < this.dims.length; ++i) {
            n *= this.dims[i];
        }
        return n;
    }

    public int rank() {
        if (this.is0D()) {
            return 0;
        }
        return this.dims.length;
    }

    public String toString() {
        if (this.is0D()) {
            return String.valueOf(this.dims[0]);
        }
        if (this.is1D()) {
            return String.valueOf(this.dims[0]);
        }
        StringBuffer stringBuffer = new StringBuffer("[" + this.dims[0]);
        for (int i = 1; i < this.dims.length; ++i) {
            stringBuffer.append("," + this.dims[i]);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public boolean equals(Dimensions dimensions) {
        if (dimensions == null) {
            return false;
        }
        if (this.dims.length != dimensions.dims.length) {
            return false;
        }
        for (int i = 0; i < this.dims.length; ++i) {
            if (this.dims[i] == dimensions.dims[i]) continue;
            return false;
        }
        return true;
    }

    public int hashcode() {
        int n = 17;
        for (int i = 0; i < this.dims.length; ++i) {
            n = 37 * n + this.dims[i];
        }
        return n;
    }
}

