/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.vectorJep.values;

import org.lsmp.djep.vectorJep.Dimensions;
import org.lsmp.djep.vectorJep.values.MatrixValueI;

public class Matrix
extends Number
implements MatrixValueI {
    int rows = 0;
    int cols = 0;
    Object[][] data = null;
    Dimensions dims;

    private Matrix() {
    }

    public Matrix(int n, int n2) {
        this.rows = n;
        this.cols = n2;
        this.data = new Object[n][n2];
        this.dims = Dimensions.valueOf(n, n2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        for (int i = 0; i < this.rows; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append('[');
            for (int j = 0; j < this.cols; ++j) {
                if (j > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.data[i][j]);
            }
            stringBuffer.append(']');
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public Dimensions getDim() {
        return this.dims;
    }

    public int getNumEles() {
        return this.rows * this.cols;
    }

    public int getNumRows() {
        return this.rows;
    }

    public int getNumCols() {
        return this.cols;
    }

    public void setEle(int n, Object object) {
        int n2 = n / this.cols;
        int n3 = n % this.cols;
        this.data[n2][n3] = object;
    }

    public void setEle(int n, int n2, Object object) {
        this.data[n][n2] = object;
    }

    public Object getEle(int n) {
        int n2 = n / this.cols;
        int n3 = n % this.cols;
        return this.data[n2][n3];
    }

    public Object getEle(int n, int n2) {
        return this.data[n][n2];
    }

    public Object[][] getEles() {
        return this.data;
    }

    public void setEles(MatrixValueI matrixValueI) {
        if (!this.dims.equals(matrixValueI.getDim())) {
            return;
        }
        for (int i = 0; i < this.rows; ++i) {
            System.arraycopy(((Matrix)matrixValueI).data[i], 0, this.data[i], 0, this.cols);
        }
    }

    public int intValue() {
        return ((Number)this.data[0][0]).intValue();
    }

    public long longValue() {
        return ((Number)this.data[0][0]).longValue();
    }

    public float floatValue() {
        return ((Number)this.data[0][0]).floatValue();
    }

    public double doubleValue() {
        return ((Number)this.data[0][0]).doubleValue();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Matrix)) {
            return false;
        }
        Matrix matrix = (Matrix)object;
        if (!matrix.getDim().equals(this.getDim())) {
            return false;
        }
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                if (this.data[i][j].equals(matrix.data[i][j])) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int n = 17;
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                n = 37 * n + this.data[i][j].hashCode();
            }
        }
        return n;
    }
}

