/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.xjep;

import java.io.PrintStream;
import java.util.Hashtable;
import org.lsmp.djep.xjep.ErrorCatchingVisitor;
import org.lsmp.djep.xjep.XOperator;
import org.nfunk.jep.ASTConstant;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.Node;
import org.nfunk.jep.Operator;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.ParserVisitor;
import org.nfunk.jep.function.List;

public class PrintVisitor
extends ErrorCatchingVisitor {
    public static final int FULL_BRACKET = 1;
    private int maxLen = -1;
    protected StringBuffer sb;
    protected int mode = 0;
    private Hashtable specialRules = new Hashtable();

    public void print(Node node, PrintStream printStream) {
        this.sb = new StringBuffer();
        this.acceptCatchingErrors(node, null);
        if (this.maxLen != -1) {
            while (true) {
                if (this.sb.length() < this.maxLen) {
                    printStream.print(this.sb);
                    return;
                }
                int n = this.maxLen - 2;
                for (int i = this.maxLen - 2; i >= 0; --i) {
                    char c = this.sb.charAt(i);
                    if (c != '+' && c != '-' && c != '*' && c != '/') continue;
                    n = i;
                    break;
                }
                printStream.println(this.sb.substring(0, n + 1));
                this.sb.delete(0, n + 1);
            }
        }
        printStream.print(this.sb);
    }

    public void print(Node node) {
        this.print(node, System.out);
    }

    public void println(Node node, PrintStream printStream) {
        this.print(node, printStream);
        printStream.println("");
    }

    public void println(Node node) {
        this.println(node, System.out);
    }

    public String toString(Node node) {
        this.sb = new StringBuffer();
        this.acceptCatchingErrors(node, null);
        return this.sb.toString();
    }

    public void append(String string) {
        this.sb.append(string);
    }

    public void addSpecialRule(Operator operator, PrintRulesI printRulesI) {
        this.specialRules.put(operator, printRulesI);
    }

    private void printNoBrackets(Node node) throws ParseException {
        node.jjtAccept((ParserVisitor)this, null);
    }

    private void printBrackets(Node node) throws ParseException {
        this.sb.append("(");
        this.printNoBrackets(node);
        this.sb.append(")");
    }

    private Object visitUnary(ASTFunNode aSTFunNode, Object object) throws ParseException {
        Node node = aSTFunNode.jjtGetChild(0);
        this.sb.append(aSTFunNode.getOperator().getSymbol());
        if (node instanceof ASTFunNode && ((ASTFunNode)node).isOperator()) {
            this.printBrackets(node);
        } else {
            this.printNoBrackets(node);
        }
        return object;
    }

    public Object visit(ASTFunNode aSTFunNode, Object object) throws ParseException {
        if (!aSTFunNode.isOperator()) {
            return this.visitFun(aSTFunNode);
        }
        if (aSTFunNode instanceof PrintRulesI) {
            ((PrintRulesI)aSTFunNode).append((Node)aSTFunNode, this);
            return null;
        }
        if (aSTFunNode.getOperator() == null) {
            throw new ParseException("Null operator in print for " + aSTFunNode);
        }
        if (this.specialRules.containsKey(aSTFunNode.getOperator())) {
            ((PrintRulesI)this.specialRules.get(aSTFunNode.getOperator())).append((Node)aSTFunNode, this);
            return null;
        }
        if (aSTFunNode.getPFMC() instanceof List) {
            this.append("[");
            for (int i = 0; i < aSTFunNode.jjtGetNumChildren(); ++i) {
                if (i > 0) {
                    this.append(",");
                }
                aSTFunNode.jjtGetChild(i).jjtAccept((ParserVisitor)this, null);
            }
            this.append("]");
            return null;
        }
        if (((XOperator)aSTFunNode.getOperator()).isUnary()) {
            return this.visitUnary(aSTFunNode, object);
        }
        if (((XOperator)aSTFunNode.getOperator()).isBinary()) {
            XOperator xOperator;
            Node node = aSTFunNode.jjtGetChild(0);
            Node node2 = aSTFunNode.jjtGetChild(1);
            XOperator xOperator2 = (XOperator)aSTFunNode.getOperator();
            if ((this.mode & 1) != 0) {
                this.printBrackets(node);
            } else if (node instanceof ASTFunNode && ((ASTFunNode)node).isOperator()) {
                xOperator = (XOperator)((ASTFunNode)node).getOperator();
                if (xOperator2 == xOperator) {
                    if (xOperator2.getBinding() == 4 && xOperator2.isAssociative()) {
                        this.printNoBrackets(node);
                    } else if (xOperator2.useBindingForPrint()) {
                        this.printNoBrackets(node);
                    } else {
                        this.printBrackets(node);
                    }
                } else if (xOperator2.getPrecedence() == xOperator.getPrecedence()) {
                    if (xOperator.getBinding() == 4 && xOperator.isAssociative()) {
                        this.printNoBrackets(node);
                    } else if (xOperator.useBindingForPrint()) {
                        this.printNoBrackets(node);
                    } else {
                        this.printBrackets(node);
                    }
                } else if (xOperator2.getPrecedence() > xOperator.getPrecedence()) {
                    this.printNoBrackets(node);
                } else {
                    this.printBrackets(node);
                }
            } else {
                this.printNoBrackets(node);
            }
            this.sb.append(aSTFunNode.getOperator().getSymbol());
            if ((this.mode & 1) != 0) {
                this.printBrackets(node2);
            } else if (node2 instanceof ASTFunNode && ((ASTFunNode)node2).isOperator()) {
                xOperator = (XOperator)((ASTFunNode)node2).getOperator();
                if (xOperator2 == xOperator) {
                    if (xOperator2.getBinding() == 8 || xOperator2.isAssociative()) {
                        this.printNoBrackets(node2);
                    } else {
                        this.printBrackets(node2);
                    }
                } else if (xOperator2.getPrecedence() == xOperator.getPrecedence()) {
                    if (xOperator2.getBinding() == 4 && xOperator2.isAssociative()) {
                        this.printNoBrackets(node2);
                    } else {
                        this.printBrackets(node2);
                    }
                } else if (xOperator2.getPrecedence() > xOperator.getPrecedence()) {
                    this.printNoBrackets(node2);
                } else {
                    this.printBrackets(node2);
                }
            } else {
                this.printNoBrackets(node2);
            }
        }
        return null;
    }

    private Object visitFun(ASTFunNode aSTFunNode) throws ParseException {
        this.sb.append(aSTFunNode.getName() + "(");
        for (int i = 0; i < aSTFunNode.jjtGetNumChildren(); ++i) {
            if (i > 0) {
                this.sb.append(",");
            }
            aSTFunNode.jjtGetChild(i).jjtAccept((ParserVisitor)this, null);
        }
        this.sb.append(")");
        return null;
    }

    public Object visit(ASTVarNode aSTVarNode, Object object) throws ParseException {
        this.sb.append(aSTVarNode.getName());
        return object;
    }

    public Object visit(ASTConstant aSTConstant, Object object) {
        this.sb.append(aSTConstant.getValue());
        return object;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int n, boolean bl) {
        this.mode = bl ? (this.mode |= n) : (this.mode ^= n);
    }

    public int getMaxLen() {
        return this.maxLen;
    }

    public void setMaxLen(int n) {
        this.maxLen = n;
    }

    public static interface PrintRulesI {
        public void append(Node var1, PrintVisitor var2) throws ParseException;
    }
}

