/*
 * MyThread.h
 *
 *  Created on: 8 Jan 2014
 *      Author: rafles01
 */

#ifndef MYTHREAD_H_
#define MYTHREAD_H_

#include <ting/net/Lib.hpp>
#include <ting/net/TCPSocket.hpp>
#include <ting/net/TCPServerSocket.hpp>
#include <ting/WaitSet.hpp>
#include <ting/mt/Thread.hpp>

#include <iostream>
#include <string>

#include "MyTime.h"
#include "QueryRecData.h"

#define BUFFER_SIZE 4096*100
#define TIMEOUT  10
const string WWWDIR = "www/";
const string indexes[2] = {"/index.html","/index.htm"};

using namespace std;
using namespace ting::net;

class MyThread : public ting::mt::Thread{
private:
  int status = 2;
public:
  bool doCycle = true;

  MyThread(){
	  status=2;
	  doCycle=true;
  }
  static ting::net::TCPServerSocket listenSock;
  void setStyle(int st) {
	  status=st;
  }
  int getStyle() {
	return status;
  }
  ting::net::TCPSocket sock;
  void waitForData() {
	  sock = MyThread::listenSock.Accept();
	  status = 1;
  }

  void  doResponseRequest(MyTime& czasPob,ting::Array<ting::u8>& data) {
	 /*
	 * Validate request CHARS
	 * acceptable char <= 127
	 */
	string txt ="";
	txt.assign((char*)data.Begin());
	for(unsigned int i=0;i<txt.size();i++) {
		if(txt.at(i)>127) {
		   cout<<" break "<<endl;
		   break;
		   }
	   }

	/*
	 * Parse request header
	 */
	QueryRecData pars(txt);
	/*
	 *      GET URL
	 */
	string url = pars.getUrl();
	if(pars.fileExist(WWWDIR+url)) {
		bool cache;// if true = 304 code will be returned to browser
		string str=pars.setHeader(WWWDIR+url,cache);
		ting::Buffer<ting::u8> data2((ting::u8*)str.c_str(),str.size());
		// sending header
			try {
				sock.Send(data2);
			} catch(ting::net::Exc &e) {
				// sending was stopped
				std::cout << "Error: " << e.What() << endl;
				sock.Close();
			}
			//delete data2.Begin();

		if(!cache) {
			//send data
			size_t fileSize = pars.getFileSize(WWWDIR+url);
			ting::Buffer<ting::u8> data3((ting::u8*)pars.getData(WWWDIR+url),fileSize);
			size_t x=0;
				try {
					while(x < fileSize) {
						x +=sock.Send(data3,x);
						}
				} catch(ting::net::Exc &e) {
					// sending was stopped
					std::cout << "Error: " << e.What() << endl;
					sock.Close();
				}
			delete data3.Begin();
			}
		std::cout <<czasPob.getAcTimeStamp() << " "<<url<<endl;
		} else {
			//if(pars.getFileExtention())
			//it is directory
			bool jest = false;
			if(pars.fileOrDirExist(WWWDIR+url)) {
				for(unsigned int i=0;i<2;i++) {
					if(pars.fileExist(WWWDIR+url+indexes[i])) {
						jest = true;
						// send header
						bool cache;// if true = 304 code will be returned to browser
						string str=pars.setHeader(WWWDIR+url+indexes[i],cache);
						ting::Buffer<ting::u8> data2((ting::u8*)str.c_str(),str.size());

						try {
							sock.Send(data2);
						} catch(ting::net::Exc &e) {
							// sending was stopped
							std::cout << "Error: " << e.What() << endl;
							sock.Close();
						}
						//delete data2.Begin();

						if(!cache) {
							// send data
							size_t fileSize = pars.getFileSize(WWWDIR+url+indexes[i]);
							ting::Buffer<ting::u8> data3((ting::u8*)pars.getData(WWWDIR+url+indexes[i]),fileSize);
							size_t x=0;
								try {
									while(x < fileSize) {
										x +=sock.Send(data3,x);
										}
								} catch(ting::net::Exc &e) {
									// sending was stopped
									std::cout << "Error: " << e.What() << endl;
									sock.Close();
								}
							delete data3.Begin();
							}

						std::cout <<czasPob.getAcTimeStamp() << " "<<url<<endl;
						break;
						}
				}
			}
			if(!jest) {
				bool cache;// if true = 304 code will be returned to browser
				string str=pars.setHeader(WWWDIR+url,cache);
				str+="<html><body><h1>404</h1></body></html>";
				ting::Buffer<ting::u8> data2((ting::u8*)str.c_str(),str.size());
				try {
					sock.Send(data2);
				} catch(ting::net::Exc &e) {
					// sending was stopped
					std::cout << "Error: " << e.What() << endl;
					sock.Close();
				}
				//delete data2.Begin();
				std::cout <<czasPob.getAcTimeStamp() << "URL does not exists "<<url<<endl;
			}
		}
	sock.Close();
  }

  void Run() {
	 while(doCycle) {
	  Sleep(10);
	  if(status!=2) {
	    status = 1;
		unsigned bRec = 0;
		unsigned bRec2 = 0;
		MyTime czasPob;

		//ting::u8 *rawBuf = new ting::u8[BUFFER_SIZE];
		//ting::Buffer<ting::u8> data(rawBuf,BUFFER_SIZE);
		ting::Array<ting::u8> data(BUFFER_SIZE);

		while(bRec2 < BUFFER_SIZE){
			bRec2=bRec;
			bRec+=sock.Recv(data,bRec2);

			// download finished
			if(bRec2=bRec && bRec>0) {
					try {
						doResponseRequest(czasPob,data);
					} catch(ting::net::Exc &e) {
						std::cout << "Blad:" << e.What() << endl;
						sock.Close();
					}
				break;
				}

			// timeout
			if(czasPob.upTime()>TIMEOUT) {
				std::cout << ""<<czasPob.getAcTime() << " : Recive Timeout "<<TIMEOUT<<"s, host: "
				<< sock.GetRemoteAddress().host.ToString() << endl;
				bRec = 0;
				sock.Close();
				break;
				}
    	 	}

    		data.Reset();
			status = 2;
	  	  }
  	  }
    };
};

#endif /* MYTHREAD_H_ */
