/*
 * QuaryRecData.h
 *
 *  Created on: 13 Jan 2014
 *      Author: rafles01
 */

#ifndef QUERYRECDATA_H_
#define QUERYRECDATA_H_

#include <vector>
#include <iostream>
#include <string>
#include <strstream>
#include <sstream>
#include <algorithm>
#include <fstream>
#include <sys/stat.h>

#include <time.h>
#include "MyTime.h"

#define SENAME "recone.org"
const unsigned  int MAXITEMS = 102;
const string whiteSpaces = " \f\n\r\t\v";

using namespace std;

class QueryRecData {
private:
	vector<vector<string> > tree;
	string mime1[MAXITEMS] ={
			"html","htm","shtml",
			"css",
			"xml","rss",
			"gif",
			"jpeg","jpg",
			"js",
			"atom",

			"mml",
			"txt",
			"jad",
			"wml",
			"htc",

			"png",
			"tif","tiff"
			"wbmp",
			"ico",
			"jng",
			"bmp",
			"svg","svgz",

			"jar","war","ear",
			"json",
			"hqx",
			"doc",
			"pdf",
			"ps","eps","ai",
			"rtf",
			"xls",
			"ppt",
			"wmlc",
			"kml",
			"kmz",
			"7z",
			"cco",
			"jardiff",
			"jnlp",
			"run",
			"pl","pm",
			"prc","pdb",
			"rar",
			"rpm",
			"sea",
			"swf",
			"sit",
			"tcl","tk",
			"der","pem","crt",
			"xpi",
			"xhtml",
			"zip",

			"bin","exe","dll",
			"deb",
			"dmg",
			"eot",
			"iso","img",
			"msi","msp","msm",
			"ogx",

			"mid","midi","kar",
			"mpga","mpega","mp2","mp3","mp4a",
			"oga","ogg","spx",
			"ra",
			"weba",

			"3gpp","3gp",
			"mp4",
			"mpeg","mpg","mpe",
			"ogv",
			"mov",
			"webm",
			"flv",
			"mng",
			"asx","asf",
			"wmv",
			"avi"
	};
	string mime2[MAXITEMS] ={
			"text/html","text/html","text/html",
			"text/css",
			"text/xml ","text/xml",
			"image/gif",
			"image/jpeg","image/jpeg",
			"application/x-javascript",
			"application/atom+xml",
			"text/mathml",
			"text/plain",
			"text/vnd.sun.j2me.app-descriptor",
			"text/vnd.wap.wml",
			"text/x-component",
			"image/png",
			"image/tiff","image/tiff",
			"image/vnd.wap.wbmp",
			"image/x-icon",
			"image/x-jng",
			"image/x-ms-bmp",
			"image/svg+xml","image/svg+xml",
			"application/java-archive","application/java-archive","application/java-archive",
			"application/json",
			"application/mac-binhex40",
			"application/msword",
			"application/pdf",
			"application/postscript","application/postscript","application/postscript",
			"application/rtf",
			"application/vnd.ms-excel",
			"application/vnd.ms-powerpoint",
			"application/vnd.wap.wmlc",
			"application/vnd.google-earth.kml+xml",
			"application/vnd.google-earth.kmz",
			"application/x-7z-compressed",
			"application/x-cocoa",
			"application/x-java-archive-diff",
			"application/x-java-jnlp-file",
			"application/x-makeself",
			"application/x-perl","application/x-perl",
			"application/x-pilot","application/x-pilot",
			"application/x-rar-compressed",
			"application/x-redhat-package-manager",
			"application/x-sea",
			"application/x-shockwave-flash",
			"application/x-stuffit",
			"application/x-tcl","application/x-tcl",
			"application/x-x509-ca-cert","application/x-x509-ca-cert","application/x-x509-ca-cert",
			"application/x-xpinstall",
			"application/xhtml+xml",
			"application/zip",
			"application/octet-stream","application/octet-stream","application/octet-stream",
			"application/octet-stream",
			"application/octet-stream",
			"application/octet-stream",
			"application/octet-stream","application/octet-stream",
			"application/octet-stream","application/octet-stream","application/octet-stream",
			"application/ogg",
			"audio/midi","audio/midi","audio/midi",
			"audio/mpeg","audio/mpeg","audio/mpeg","audio/mpeg","audio/mpeg",
			"audio/ogg","audio/ogg","audio/ogg",
			"audio/x-realaudio",
			"audio/webm",
			"video/3gpp","video/3gpp",
			"video/mp4",
			"video/mpeg","video/mpeg","video/mpeg",
			"video/ogg",
			"video/quicktime",
			"video/webm",
	};
public:

/* =============== basics =============*/
	void trimRight( std::string& str,  const std::string& trimChars = whiteSpaces )
	{
	   std::string::size_type pos = str.find_last_not_of( trimChars );
	   str.erase( pos + 1 );
	}


	void trimLeft( std::string& str,  const std::string& trimChars = whiteSpaces )
	{
	   std::string::size_type pos = str.find_first_not_of( trimChars );
	   str.erase( 0, pos );
	}


	void trim( std::string& str, const std::string& trimChars = whiteSpaces )
	{
	   trimRight( str, trimChars );
	   trimLeft( str, trimChars );
	}
/* ==================================== */

	void ReplaceStringInPlace(std::string& subject, const std::string& search,const std::string& replace) {
	    size_t pos = 0;
	    while ((pos = subject.find(search, pos)) != std::string::npos) {
	         subject.replace(pos, search.length(), replace);
	         pos += replace.length();
	    }
	}
/*
 * Creates vector from added string - header HTTP request
 */
	QueryRecData(string st){
		vector<string> listRows = QueryRecData::splitText(st);
		for(unsigned int ile=0;ile<listRows.size();ile++) {
			if(ile==0) {
				tree.push_back(explodeSuper(listRows.at(ile),' '));
			 } else {
				tree.push_back(QueryRecData::explode(listRows.at(ile),':'));
			 }
		}
	}

	string getIfModyfied() {
		for(unsigned int ile=0;ile<tree.size();ile++) {
			string *list = tree.at(ile).data();
			if(list[0]=="If-Modified-Since") {
				return list[1];
			}
		}
		return " ";
	}
/*
 *  Creates header
 */
string setHeader(string url,bool &cached) {
		cached  = false;
		bool ex = false;
		if(fileExist(url)) ex = true;

		string str ="";

			if(ex) {
				if(getIfModyfied()==getFileModyfication(url)) {
				  cached = true;
				  str  ="HTTP/1.0 304 OK\n";
				} else
					str  ="HTTP/1.0 200 OK\n";
			} else
				str  ="HTTP/1.0 404 OK\n";

		str +="Connection: Close\n"; // Keep-Alive
		str +="Server: "SENAME"\n";
		MyTime ti;
		char *ta=ti.getGMTime(ti.getAcTimeStamp());
		str +="Date: "+(string)ta+"\n";

		if(ex) {
			string ext = getFileExtention(url);
			for(unsigned int i=0;i<MAXITEMS;i++) {
				if(mime1[i]==ext) {
				  str +="Content-Type: "+mime2[i]+"\n";
				  break;
				} else {
				  if(i==(MAXITEMS-1)) {
						str +="Content-Type: "+mime2[0]+"\n";
				  }
				}
			}
			size_t size=0;
			size=getFileSize(url);
			ostringstream ss;
			ss << size;
			str +="Content-Length: "+ss.str()+"\n";
			str +="Last-Modified:"+getFileModyfication(url)+"\n";
			str +="Keep-Alive: timeout=5, max=98 \n";
			str +="Cache-Control: max-age=315360000, public\n";
			//str +="Expires: Thu, 31 Dec 2037 23:55:55 GMT\n";

		} else {
			str +="Content-Type: "+mime2[0]+"\n";
		}
		str+="\n";
		return str;
	}

/*
 * Checks if this points to file
 */
bool isFile(const char* path) {
	    struct stat buf;
	    stat(path, &buf);
	    return S_ISREG(buf.st_mode);
	}
/*
 * Is it a directory ?
 */
bool isDir(const char* path) {
		if(isFile(path))
			return false;
		else
			return true;
	}
/*
 * Checks if file exists
 * if directory returns false
 */
bool fileExist(string name ){
		if(!isFile(name.c_str())) return false;
		ifstream f(name.c_str());
		    if (f.good()) {
		        f.close();
		        return true;
		    } else {
		        f.close();
		        return false;
		    }
	}
/*
 * checks if file or directory exists
 */

bool fileOrDirExist(string name ){
		ifstream f(name.c_str());
		    if (f.good()) {
		        f.close();
		        return true;
		    } else {
		        f.close();
		        return false;
		    }
	}
/*
 * Returns data read from local file
 */
char* getData(string st) {
		size_t size;
		  ifstream file(st.c_str(),ios::in|ios::binary|ios::ate);
		  if (file.is_open())  {
		    size = file.tellg();
		    char * memblock = new char [size];
		    file.seekg (0, ios::beg);
		    file.read (memblock, size);
		    file.close();
		    return memblock;
		  }
		  return 0;
	}
/*
 * Gets local file size
 */
size_t getFileSize(string st) {
     ifstream file(st.c_str(),ios::in|ios::binary|ios::ate);
      if (file.is_open())  {
    	 return file.tellg();
      	 }
      return NULL;
    }
/*
 * Gets URL send in request
 */
string getUrl() {
		for(unsigned int ile=0;ile<tree.size();ile++) {
			string* list = tree[ile].data();
			if(list[0]=="GET") {
				return list[1];
			}
		}
		return "";
	}
/*
 * Gets the file extension
 */
string getFileExtention(string file) {
		string buf="";
		bool dot=false;
		for(unsigned int i = 0; i <file.length(); i++ ) {
			   	   if( file[i] == '.' ) {
			   		   dot=true; buf="";
			   	   } else
			   		   if(dot==true) {
			   			   buf+=file[i];
			   	   	   	   }
		   	   }
		   return buf;
	}
/*
 * Converts string to list of rows
 */
vector<string> splitText(string st) {
		vector<string> list;
		std::istrstream in(st.c_str());
		string line;
		string::size_type pos = 0;
		while(std::getline(in,line)){
			replace(line.begin(), line.end(),'\r',' ');
			replace(line.begin(), line.end(),'\n',' ');
			list.push_back(line);
		}
		return list;
	}
/*
 * equal to php explode
 */
vector<string> explodeSuper(string st,char pr) {
		vector<string> list;
		list.clear();
		list.resize(0);
		int start =0, krok =0;
		for(unsigned int x=0;x<st.length();x++) {
			if(st.at(x)==pr){
				string buf = st.substr(start,krok);
				trim(buf);
				list.push_back(buf);
				start=x;
				krok=0;
			}
			krok++;
		}
		return list;
	}
/*
 * Brakes string on parts, creates vector of small strings
 */
vector<string> explode(string st, char pr) {
		vector<string> list;
		list.clear();
		list.resize(0);
		string line1="",line2 ="";
		bool sw=false;
		for(unsigned int x=0;x<st.length();x++) {
			if(st.at(x)==pr && sw==false) {
					sw=true;
				} else {
					if(sw==false) {
						line1+=st.at(x);
					} else {
						line2+=st.at(x);
					}
				}
			}
		trim(line1);
		trim(line2);
		list.push_back(line1);
		list.push_back(line2);
		return list;
	}
/*
 * Returns file last modyfication time in string
 */
string getFileModyfication(string file) {
	   struct stat attrib;
	   stat(file.c_str(), &attrib);
	   char date[250];
	   strftime(date,250,"%a, %d %b %Y %X GMT", gmtime(&(attrib.st_ctime)));
	   return (string)date;
	}
}; /* namespace Time */
#endif /* QUERYRECDATA_H_ */
