//============================================================================
// Name        : Small http server
// Author      : Rafal Lesniewski
// Version     :
// Copyright   : GNU
// Description : C++
//============================================================================

#include <ting/net/Lib.hpp>
#include <ting/net/TCPSocket.hpp>
#include <ting/net/TCPServerSocket.hpp>
#include <ting/WaitSet.hpp>

#include <iostream>
#include <string>
#include <stdio.h>
#include <time.h>

#include "MyTime.h"
#include "MyThread.h"
#include "QueryRecData.h"

#define NMBTH 32

using namespace std;

int main() {

		MyTime czas;
	    ting::net::Lib socketsLib;
	    MyThread::listenSock.Open(8080);
	    ting::WaitSet waitSet(32);
	    waitSet.Add(MyThread::listenSock, ting::Waitable::READ);

	    MyThread *th[NMBTH];
	    for(int x=0;x<NMBTH;x++) {
	    	th[x] = new MyThread();
	    	th[x]->Start(); // start thread
	    	}
	    int st=0;
	    bool search;

	    while(true) {
	    	search = true;
	    	waitSet.Wait();
	    	if(MyThread::listenSock.CanRead()){
				st=0;
				MyTime clock;
				while(search) {
					if(th[st % NMBTH]->getStyle()==2) {
						th[st % NMBTH]->waitForData();
						search=false;
						}
					st++;
					if(clock.upTime()>2) {
						cout<< "Can't find free thread"<<endl;
						search=false;
						}
				}
	    	}
		}

	return 0;
}
